"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewErrorsCount = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _monitor_errors_count = require("../../../../monitor_details/monitor_summary/monitor_errors_count");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewErrorsCount = ({
  monitorIds,
  from,
  to,
  locations
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const time = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "overviewErrorsCount",
    align: "left",
    customHeight: "70px",
    reportType: _public2.ReportTypes.SINGLE_METRIC,
    attributes: [{
      time,
      reportDefinitions: {
        'monitor.id': monitorIds.length > 0 ? monitorIds : ['false-monitor-id'],
        ...(locations !== null && locations !== void 0 && locations.length ? {
          'observer.geo.name': locations
        } : {})
      },
      dataType: 'synthetics',
      selectedMetricField: 'monitor_errors',
      name: _monitor_errors_count.ERRORS_LABEL
    }]
  });
};
exports.OverviewErrorsCount = OverviewErrorsCount;