"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _labels = require("./labels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorTags = ({
  tags
}) => {
  const [toDisplay, setToDisplay] = (0, _react.useState)(5);
  const tagsToDisplay = tags.slice(0, toDisplay);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    css: {
      width: '100%'
    }
  }, tagsToDisplay.map(tag =>
  /*#__PURE__*/
  // filtering only makes sense in monitor list, where we have summary
  _react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: "hollow",
    className: "eui-textTruncate",
    css: {
      display: 'flex',
      maxWidth: 120
    }
  }, tag)), tags.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(tags.length);
    },
    onClickAriaLabel: _labels.EXPAND_TAGS_LABEL
  }, "+", tags.length - 5));
};
exports.MonitorTags = MonitorTags;