"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectMonitorDisclaimer = exports.PROJECT_MONITOR_TITLE = exports.DeleteMonitor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _state = require("../../../../state");
var _kibana_service = require("../../../../../../utils/kibana_service");
var labels = _interopRequireWildcard(require("./labels"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteMonitor = ({
  name,
  reloadPage,
  configId,
  isProjectMonitor,
  setMonitorPendingDeletion
}) => {
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const handleConfirmDelete = () => {
    setIsDeleting(true);
  };
  const {
    status: monitorDeleteStatus
  } = (0, _public.useFetcher)(() => {
    if (isDeleting) {
      return (0, _state.fetchDeleteMonitor)({
        configId
      });
    }
  }, [configId, isDeleting]);
  (0, _react.useEffect)(() => {
    if (!isDeleting) {
      return;
    }
    if (monitorDeleteStatus === _public.FETCH_STATUS.FAILURE) {
      _kibana_service.kibanaService.toasts.addDanger({
        title: (0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteMonitorFailure"
        }, labels.MONITOR_DELETE_FAILURE_LABEL))
      }, {
        toastLifeTimeMs: 3000
      });
    } else if (monitorDeleteStatus === _public.FETCH_STATUS.SUCCESS) {
      reloadPage();
      _kibana_service.kibanaService.toasts.addSuccess({
        title: (0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "uptimeDeleteMonitorSuccess"
        }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorDeleteSuccessMessage.name', {
          defaultMessage: 'Deleted "{name}"',
          values: {
            name
          }
        })))
      }, {
        toastLifeTimeMs: 3000
      });
    }
    if (monitorDeleteStatus === _public.FETCH_STATUS.SUCCESS || monitorDeleteStatus === _public.FETCH_STATUS.FAILURE) {
      setIsDeleting(false);
      setMonitorPendingDeletion(null);
    }
  }, [setIsDeleting, isDeleting, reloadPage, monitorDeleteStatus, setMonitorPendingDeletion, name]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.synthetics.monitorManagement.deleteMonitorNameLabel', {
      defaultMessage: 'Delete "{name}" monitor?',
      values: {
        name
      }
    }),
    onCancel: () => setMonitorPendingDeletion(null),
    onConfirm: handleConfirmDelete,
    cancelButtonText: labels.NO_LABEL,
    confirmButtonText: labels.YES_LABEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isDeleting
  }, isProjectMonitor && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: PROJECT_MONITOR_TITLE
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(ProjectMonitorDisclaimer, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
exports.DeleteMonitor = DeleteMonitor;
const PROJECT_MONITOR_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorList.disclaimer.title', {
  defaultMessage: 'Deleting this monitor will not remove it from the project source'
});
exports.PROJECT_MONITOR_TITLE = PROJECT_MONITOR_TITLE;
const ProjectMonitorDisclaimer = () => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.monitorList.disclaimer.label",
    defaultMessage: "To delete it completely and stop it from being pushed again in the future, delete it from the project source. {docsLink}.",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsProjectMonitorDisclaimerLearnMoreLink",
        href: "https://elastic.co/guide/en/observability/current/synthetics-manage-monitors.html#manage-monitors-delete",
        target: "_blank"
      }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.projectDelete.docsLink', {
        defaultMessage: 'Learn more'
      }))
    }
  });
};
exports.ProjectMonitorDisclaimer = ProjectMonitorDisclaimer;