"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _monitor_async_error = require("./monitor_errors/monitor_async_error");
var _list_filters = require("../common/monitor_filters/list_filters");
var _monitor_list = require("./monitor_list_table/monitor_list");
var _monitor_stats = require("./monitor_stats/monitor_stats");
var _overview_status = require("../../../state/overview_status");
var _alerting_callout = require("../../common/alerting_callout/alerting_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorListContainer = ({
  isEnabled,
  monitorListProps
}) => {
  const {
    pageState,
    error,
    loading: monitorsLoading,
    syntheticsMonitors,
    total,
    absoluteTotal,
    loadPage,
    reloadPage,
    handleFilterChange
  } = monitorListProps;
  const {
    status: overviewStatus
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);

  // TODO: Display inline errors in the management table

  // const { errorSummaries, loading: errorsLoading } = useInlineErrors({
  //   onlyInvalidMonitors: false,
  //   sortField: pageState.sortField,
  //   sortOrder: pageState.sortOrder,
  // });

  if (!isEnabled && absoluteTotal === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerting_callout.AlertingCallout, null), /*#__PURE__*/_react.default.createElement(_monitor_async_error.MonitorAsyncError, null), /*#__PURE__*/_react.default.createElement(_list_filters.ListFilters, {
    handleFilterChange: handleFilterChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_monitor_stats.MonitorStats, {
    overviewStatus: overviewStatus
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_monitor_list.MonitorList, {
    syntheticsMonitors: syntheticsMonitors,
    total: total,
    pageState: pageState,
    error: error,
    loading: monitorsLoading,
    loadPage: loadPage,
    reloadPage: reloadPage,
    overviewStatus: overviewStatus
  }));
};
exports.MonitorListContainer = MonitorListContainer;