"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewStatus = useOverviewStatus;
var _react = require("react");
var _reactRedux = require("react-redux");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _state = require("../../../state");
var _overview_status = require("../../../state/overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useOverviewStatus({
  scopeStatusByLocation
}) {
  const pageState = (0, _reactRedux.useSelector)(_state.selectOverviewPageState);
  const {
    status,
    error,
    loaded
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const reload = (0, _react.useCallback)(() => {
    dispatch(_overview_status.fetchOverviewStatusAction.get({
      pageState,
      scopeStatusByLocation
    }));
  }, [dispatch, pageState, scopeStatusByLocation]);
  (0, _react.useEffect)(() => {
    if (loaded) {
      dispatch(_overview_status.quietFetchOverviewStatusAction.get({
        pageState,
        scopeStatusByLocation
      }));
    } else {
      reload();
    }
  }, [dispatch, reload, lastRefresh, pageState, loaded, scopeStatusByLocation]);
  return {
    status,
    error,
    reload
  };
}