"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchField = SearchField;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SearchField() {
  const {
    query
  } = (0, _hooks.useGetUrlParams)();
  const [_, updateUrlParams] = (0, _hooks.useUrlParams)();
  const [search, setSearch] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => {
    if (search !== query) {
      updateUrlParams({
        query: search
      });
    }
  }, 300, [search]);

  // Hydrate search input
  const hasInputChangedRef = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (query !== search && !hasInputChangedRef.current) {
      setSearch(query);
    }

    // Run only to sync url with input
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [query]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    css: {
      minWidth: 230
    },
    fullWidth: true,
    placeholder: PLACEHOLDER_TEXT,
    value: search,
    onChange: e => {
      var _e$target$value;
      hasInputChangedRef.current = true;
      setSearch((_e$target$value = e.target.value) !== null && _e$target$value !== void 0 ? _e$target$value : '');
    },
    isClearable: true,
    "aria-label": PLACEHOLDER_TEXT,
    "data-test-subj": "syntheticsOverviewSearchInput"
  });
}
const PLACEHOLDER_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.placeholder', {
  defaultMessage: `Search by name, URL, host, tag, project or location`
});