"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilters = void 0;
exports.useMonitorFiltersState = useMonitorFiltersState;
var _react = require("react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _overview_status = require("../../../../state/overview_status");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _saved_objects = require("../../../../../../../common/types/saved_objects");
var _state = require("../../../../state");
var _hooks = require("../../../../hooks");
var _filter_fields = require("./filter_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggs = {
  monitorTypes: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.MONITOR_TYPE}.keyword`,
      size: 10000
    }
  },
  tags: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.TAGS}`,
      size: 10000
    }
  },
  locations: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.LOCATIONS}.id`,
      size: 10000
    }
  },
  projects: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.PROJECT_ID}`,
      size: 10000
    }
  },
  schedules: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorType}.attributes.${_runtime_types.ConfigKey.SCHEDULE}.number`,
      size: 10000
    }
  }
};
const useFilters = () => {
  const {
    savedObjects
  } = (0, _public.useKibana)().services;
  const {
    data
  } = (0, _public2.useFetcher)(async () => {
    return savedObjects === null || savedObjects === void 0 ? void 0 : savedObjects.client.find({
      type: _saved_objects.syntheticsMonitorType,
      perPage: 0,
      aggs
    });
  }, []);
  const filtersData = (0, _reactRedux.useSelector)(_overview_status.selectFiltersData);
  const dispatch = (0, _reactRedux.useDispatch)();
  const newFiltersData = (0, _react.useMemo)(() => {
    var _ref, _monitorTypes$buckets, _monitorTypes$buckets2, _tags$buckets$map, _tags$buckets, _locations$buckets$ma, _locations$buckets, _projects$buckets$fil, _projects$buckets, _schedules$buckets$ma, _schedules$buckets;
    const {
      monitorTypes,
      tags,
      locations,
      projects,
      schedules
    } = (_ref = data === null || data === void 0 ? void 0 : data.aggregations) !== null && _ref !== void 0 ? _ref : {};
    return {
      monitorTypes: (_monitorTypes$buckets = monitorTypes === null || monitorTypes === void 0 ? void 0 : (_monitorTypes$buckets2 = monitorTypes.buckets) === null || _monitorTypes$buckets2 === void 0 ? void 0 : _monitorTypes$buckets2.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _monitorTypes$buckets !== void 0 ? _monitorTypes$buckets : [],
      tags: (_tags$buckets$map = tags === null || tags === void 0 ? void 0 : (_tags$buckets = tags.buckets) === null || _tags$buckets === void 0 ? void 0 : _tags$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _tags$buckets$map !== void 0 ? _tags$buckets$map : [],
      locations: (_locations$buckets$ma = locations === null || locations === void 0 ? void 0 : (_locations$buckets = locations.buckets) === null || _locations$buckets === void 0 ? void 0 : _locations$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _locations$buckets$ma !== void 0 ? _locations$buckets$ma : [],
      projects: (_projects$buckets$fil = projects === null || projects === void 0 ? void 0 : (_projects$buckets = projects.buckets) === null || _projects$buckets === void 0 ? void 0 : _projects$buckets.filter(({
        key
      }) => key).map(({
        key,
        doc_count: count
      }) => ({
        label: key,
        count
      }))) !== null && _projects$buckets$fil !== void 0 ? _projects$buckets$fil : [],
      schedules: (_schedules$buckets$ma = schedules === null || schedules === void 0 ? void 0 : (_schedules$buckets = schedules.buckets) === null || _schedules$buckets === void 0 ? void 0 : _schedules$buckets.map(({
        key,
        doc_count: count
      }) => ({
        label: String(key),
        count
      }))) !== null && _schedules$buckets$ma !== void 0 ? _schedules$buckets$ma : []
    };
  }, [data]);
  (0, _react.useEffect)(() => {
    if (data) {
      dispatch((0, _overview_status.setListOfFiltersActions)(newFiltersData));
    }
  }, [data, dispatch, newFiltersData]);
  if (!data && filtersData) {
    return filtersData;
  }
  return newFiltersData;
};
exports.useFilters = useFilters;
function useMonitorFiltersState() {
  const [getUrlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const urlParams = getUrlParams();
  const filterFieldsWithQuery = (0, _react.useMemo)(() => {
    const filterFields = (0, _filter_fields.getMonitorFilterFields)();
    return [...filterFields, 'query'];
  }, []);
  const dispatch = (0, _reactRedux.useDispatch)();
  const serializeFilterValue = (0, _react.useCallback)((field, selectedValues) => {
    if (field === 'query') {
      return selectedValues !== null && selectedValues !== void 0 && selectedValues.length ? selectedValues.toString() : undefined;
    }
    return selectedValues && selectedValues.length > 0 ? JSON.stringify(selectedValues.map(value => (0, _filter_fields.getSyntheticsFilterKeyForLabel)(value, field))) : undefined;
  }, []);
  const serializeStateValues = (0, _react.useCallback)(state => {
    return filterFieldsWithQuery.reduce((acc, cur) => ({
      ...acc,
      [cur]: serializeFilterValue(cur, state[cur])
    }), {});
  }, [filterFieldsWithQuery, serializeFilterValue]);
  const handleFilterChange = (0, _react.useCallback)((field, selectedValues) => {
    // Update url to reflect the changed filter
    updateUrlParams({
      [field]: serializeFilterValue(field, selectedValues)
    });
  }, [serializeFilterValue, updateUrlParams]);
  const reduxState = (0, _reactRedux.useSelector)(_state.selectMonitorFiltersAndQueryState);
  const reduxStateSnapshot = JSON.stringify(serializeStateValues(reduxState));
  const urlState = filterFieldsWithQuery.reduce((acc, cur) => ({
    ...acc,
    [cur]: urlParams[cur]
  }), {});
  const urlStateSerializedSnapshot = JSON.stringify(serializeStateValues(urlState));
  const isUrlHydratedFromRedux = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (urlStateSerializedSnapshot !== reduxStateSnapshot) {
      if (urlStateSerializedSnapshot === '{}' && reduxStateSnapshot !== '{}' && !isUrlHydratedFromRedux.current) {
        // Hydrate url only during initialization
        updateUrlParams(serializeStateValues(reduxState));
      } else {
        dispatch((0, _state.updateManagementPageStateAction)(urlState));
        dispatch((0, _state.setOverviewPageStateAction)(urlState));
      }
    }
    isUrlHydratedFromRedux.current = true;

    // Only depend on the serialized snapshot
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [urlStateSerializedSnapshot, reduxStateSnapshot]);
  return {
    handleFilterChange,
    filterState: reduxState
  };
}