"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _hooks = require("../../../../hooks");
var _state = require("../../../../state");
var _filter_fields = require("./filter_fields");
var _use_filters = require("./use_filters");
var _filter_button = require("./filter_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mixUrlValues = (values, urlLabels) => {
  var _urlLabels$map;
  const urlValues = (_urlLabels$map = urlLabels === null || urlLabels === void 0 ? void 0 : urlLabels.map(label => ({
    label,
    count: 0
  }))) !== null && _urlLabels$map !== void 0 ? _urlLabels$map : [];
  const newValues = [...(values !== null && values !== void 0 ? values : [])];
  // add url values that are not in the values
  urlValues.forEach(urlValue => {
    if (!newValues.find(value => value.label === urlValue.label)) {
      newValues.push(urlValue);
    }
  });
  return newValues;
};
const FilterGroup = ({
  handleFilterChange
}) => {
  const data = (0, _use_filters.useFilters)();
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const urlParams = (0, _hooks.useGetUrlParams)();
  const filters = [{
    label: TYPE_LABEL,
    field: 'monitorTypes',
    values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(mixUrlValues(data.monitorTypes, urlParams.monitorTypes), 'monitorTypes', locations)
  }, {
    label: LOCATION_LABEL,
    field: 'locations',
    values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(mixUrlValues(data.locations.map(locationData => {
      const matchingLocation = locations.find(location => location.id === locationData.label);
      return {
        label: matchingLocation ? matchingLocation.label : locationData.label,
        count: locationData.count
      };
    }), urlParams.locations), 'locations', locations)
  }, {
    label: TAGS_LABEL,
    field: 'tags',
    values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(mixUrlValues(data.tags, urlParams.tags), 'tags', locations)
  }, {
    label: SCHEDULE_LABEL,
    field: 'schedules',
    values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(mixUrlValues(data.schedules, urlParams.schedules), 'schedules', locations)
  }];
  if (data.projects.length > 0) {
    filters.push({
      label: PROJECT_LABEL,
      field: 'projects',
      values: (0, _filter_fields.getSyntheticsFilterDisplayValues)(mixUrlValues(data.projects, urlParams.projects), 'projects', locations)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, filters.map((filter, index) => /*#__PURE__*/_react.default.createElement(_filter_button.FilterButton, {
    key: index,
    filter: filter,
    handleFilterChange: handleFilterChange
  })));
};
exports.FilterGroup = FilterGroup;
const TYPE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.typeLabel', {
  defaultMessage: `Type`
});
const PROJECT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.projectLabel', {
  defaultMessage: `Project`
});
const LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.locationLabel', {
  defaultMessage: `Location`
});
const TAGS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.tagsLabel', {
  defaultMessage: `Tags`
});
const SCHEDULE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.filter.frequencyLabel', {
  defaultMessage: `Frequency`
});