"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/exploratory-view-plugin/public");
var _filter_fields = require("./filter_fields");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterButton = ({
  filter,
  handleFilterChange
}) => {
  const {
    label,
    values,
    field
  } = filter;
  const [query, setQuery] = (0, _react.useState)('');
  const urlParams = (0, _hooks.useGetUrlParams)();

  // Transform the values to readable labels (if any) so that selected values are checked on filter dropdown
  const selectedValueLabels = (0, _filter_fields.getSyntheticsFilterDisplayValues)((urlParams[field] || []).map(_filter_fields.valueToLabelWithEmptyCount), field, []).map(({
    label: selectedValueLabel
  }) => selectedValueLabel);
  return /*#__PURE__*/_react.default.createElement(_public.FieldValueSelection, {
    selectedValue: selectedValueLabels,
    singleSelection: false,
    label: label,
    values: query ? values.filter(({
      label: str
    }) => str.toLowerCase().includes(query.toLowerCase())) : values,
    setQuery: setQuery,
    onChange: selectedValues => handleFilterChange(field, selectedValues),
    allowExclusions: false,
    loading: false,
    asFilterButton: true
  });
};
exports.FilterButton = FilterButton;