"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorErrorSparklines = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _monitor_errors_count = require("./monitor_errors_count");
var _use_selected_location = require("../hooks/use_selected_location");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorErrorSparklines = ({
  from,
  to,
  monitorId,
  id
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const time = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  if (!selectedLocation) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: id,
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: [{
      time,
      seriesType: 'area',
      reportDefinitions: {
        'monitor.id': monitorId,
        'observer.geo.name': [selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label]
      },
      dataType: 'synthetics',
      selectedMetricField: 'monitor_errors',
      name: _monitor_errors_count.ERRORS_LABEL,
      color: euiTheme.colors.danger,
      operationType: 'unique_count'
    }]
  });
};
exports.MonitorErrorSparklines = MonitorErrorSparklines;