"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditMonitorLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_capabilities = require("../../../../../hooks/use_capabilities");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _permissions = require("../../common/components/permissions");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditMonitorLink = () => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const canUpdatePrivateMonitor = (0, _hooks.useCanUpdatePrivateMonitor)(monitor);
  const isLinkDisabled = !canEditSynthetics || !canUpdatePrivateMonitor;
  const linkProps = isLinkDisabled ? {
    disabled: true
  } : {
    href: `${basePath}/app/synthetics/edit-monitor/${monitorId}`
  };
  return /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics,
    canUpdatePrivateMonitor: canUpdatePrivateMonitor
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "syntheticsEditMonitorLinkButton",
    fill: true,
    iconType: "pencil",
    iconSide: "left"
  }, linkProps), EDIT_MONITOR));
};
exports.EditMonitorLink = EditMonitorLink;
const EDIT_MONITOR = _i18n.i18n.translate('xpack.synthetics.monitorSummary.editMonitor', {
  defaultMessage: 'Edit monitor'
});