"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvailabilitySparklines = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _public3 = require("@kbn/exploratory-view-plugin/public");
var _availability_panel = require("./availability_panel");
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _use_selected_location = require("../hooks/use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AvailabilitySparklines = props => {
  const {
    services: {
      exploratoryView: {
        ExploratoryViewEmbeddable
      }
    }
  } = (0, _public.useKibana)();
  const monitorId = (0, _use_monitor_query_id.useMonitorQueryId)();
  const theme = (0, _public2.useTheme)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  if (!selectedLocation || !monitorId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: props.id,
    customHeight: "70px",
    reportType: _public3.ReportTypes.KPI,
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: [{
      seriesType: 'area',
      time: props,
      name: _availability_panel.AVAILABILITY_LABEL,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_availability',
      reportDefinitions: {
        'monitor.id': [monitorId],
        'observer.geo.name': [selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label]
      },
      color: theme.eui.euiColorVis1
    }]
  });
};
exports.AvailabilitySparklines = AvailabilitySparklines;