"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvailabilityPanel = exports.AVAILABILITY_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _use_selected_location = require("../hooks/use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AvailabilityPanel = props => {
  const {
    services: {
      exploratoryView: {
        ExploratoryViewEmbeddable
      }
    }
  } = (0, _public.useKibana)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const monitorId = (0, _use_monitor_query_id.useMonitorQueryId)();
  if (!selectedLocation || !monitorId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: props.id,
    align: "left",
    customHeight: "70px",
    reportType: _public2.ReportTypes.SINGLE_METRIC,
    attributes: [{
      time: props,
      name: AVAILABILITY_LABEL,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_availability',
      reportDefinitions: {
        'monitor.id': [monitorId],
        'observer.geo.name': [selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label]
      }
    }]
  });
};
exports.AvailabilityPanel = AvailabilityPanel;
const AVAILABILITY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.availability', {
  defaultMessage: 'Availability'
});
exports.AVAILABILITY_LABEL = AVAILABILITY_LABEL;