"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRecentlyViewedMonitors = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _saved_objects = require("../../../../../../common/types/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRecentlyViewedMonitors = () => {
  const [recentlyViewed, setRecentlyViewed] = (0, _useLocalStorage.default)('xpack.synthetics.recentlyViewedMonitors', []);
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    savedObjects
  } = (0, _public.useKibana)().services;
  (0, _react.useEffect)(() => {
    const newRecentlyViewed = [...new Set([...(monitorId ? [monitorId] : []), ...(recentlyViewed !== null && recentlyViewed !== void 0 ? recentlyViewed : [])])].slice(0, 5);
    if ((newRecentlyViewed === null || newRecentlyViewed === void 0 ? void 0 : newRecentlyViewed[0]) !== (recentlyViewed === null || recentlyViewed === void 0 ? void 0 : recentlyViewed[0]) || newRecentlyViewed.length !== (recentlyViewed === null || recentlyViewed === void 0 ? void 0 : recentlyViewed.length)) {
      setRecentlyViewed(newRecentlyViewed);
    }
  }, [monitorId, recentlyViewed, setRecentlyViewed]);
  const {
    data
  } = (0, _public2.useFetcher)(async () => {
    const monitorsList = recentlyViewed !== null && recentlyViewed !== void 0 ? recentlyViewed : [];
    const {
      resolved_objects: monitorObjects
    } = await savedObjects.client.bulkResolve(monitorsList.map(monId => ({
      type: _saved_objects.syntheticsMonitorType,
      id: monId
    })));
    const missingMonitors = monitorObjects.filter(mon => {
      var _mon$saved_object$err;
      return ((_mon$saved_object$err = mon.saved_object.error) === null || _mon$saved_object$err === void 0 ? void 0 : _mon$saved_object$err.statusCode) === 404;
    }).map(mon => mon.saved_object.id);
    if (missingMonitors.length > 0) {
      setRecentlyViewed(monitorsList.filter(monId => !missingMonitors.includes(monId)));
    }
    return monitorObjects.filter(({
      saved_object: monitor
    }) => Boolean(monitor.attributes) && monitor.id !== monitorId).map(({
      saved_object: monitor
    }) => ({
      key: monitor.id,
      label: monitor.attributes.name,
      locationIds: monitor.attributes.locations.map(location => location.id)
    }));
  }, [monitorId, recentlyViewed]);
  return (0, _react.useMemo)(() => {
    if ((data !== null && data !== void 0 ? data : []).length === 0) {
      return [];
    }
    return [{
      key: 'recently_viewed',
      label: RECENTLY_VIEWED,
      isGroupLabel: true
    }, ...(data !== null && data !== void 0 ? data : [])];
  }, [data]);
};
exports.useRecentlyViewedMonitors = useRecentlyViewedMonitors;
const RECENTLY_VIEWED = _i18n.i18n.translate('xpack.synthetics.monitorSummary.recentlyViewed', {
  defaultMessage: 'Recently viewed'
});