"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorName = void 0;
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _state = require("../../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorName = ({
  search = ''
}) => {
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    return (0, _state.fetchMonitorManagementList)({
      pageSize: 100,
      pageIndex: 0,
      sortField: 'name.keyword',
      sortOrder: 'asc',
      query: search
    });
  }, [search]);
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  return (0, _react.useMemo)(() => {
    const {
      monitors = []
    } = data !== null && data !== void 0 ? data : {};
    const values = monitors.map(monitor => ({
      label: monitor.attributes.name,
      key: monitor.id,
      locationIds: monitor.attributes.locations.map(location => location.id)
    }));
    return {
      values: values.filter(val => val.key !== monitorId),
      loading
    };
  }, [data, loading, monitorId]);
};
exports.useMonitorName = useMonitorName;