"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorHistory = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_monitor_details_page = require("../use_monitor_details_page");
var _hooks = require("../../../hooks");
var _synthetics_date_picker = require("../../common/date_picker/synthetics_date_picker");
var _availability_panel = require("../monitor_summary/availability_panel");
var _duration_panel = require("../monitor_summary/duration_panel");
var _duration_trend = require("../monitor_summary/duration_trend");
var _test_runs_table = require("../monitor_summary/test_runs_table");
var _monitor_errors_count = require("../monitor_summary/monitor_errors_count");
var _monitor_complete_count = require("../monitor_summary/monitor_complete_count");
var _monitor_total_runs_count = require("../monitor_summary/monitor_total_runs_count");
var _monitor_error_sparklines = require("../monitor_summary/monitor_error_sparklines");
var _availability_sparklines = require("../monitor_summary/availability_sparklines");
var _duration_sparklines = require("../monitor_summary/duration_sparklines");
var _monitor_complete_sparklines = require("../monitor_summary/monitor_complete_sparklines");
var _monitor_status_panel = require("../monitor_status/monitor_status_panel");
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _monitor_pending_wrapper = require("../monitor_pending_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATS_WIDTH_SINGLE_COLUMN_THRESHOLD = 360; // ✨ determined by trial and error

const MonitorHistory = () => {
  const [, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRangeFromUrl)();
  const {
    elementRef: statsRef,
    width: statsWidth
  } = (0, _hooks.useDimensions)();
  const statsColumns = statsWidth && statsWidth < STATS_WIDTH_SINGLE_COLUMN_THRESHOLD ? 1 : 2;
  const handleStatusChartBrushed = (0, _react.useCallback)(({
    fromUtc,
    toUtc
  }) => {
    updateUrlParams({
      dateRangeStart: fromUtc,
      dateRangeEnd: toUtc
    });
  }, [updateUrlParams]);
  const monitorId = (0, _use_monitor_query_id.useMonitorQueryId)();
  const redirect = (0, _use_monitor_details_page.useMonitorDetailsPage)();
  if (redirect) {
    return redirect;
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_pending_wrapper.MonitorPendingWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_synthetics_date_picker.SyntheticsDatePicker, {
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      flexBasis: '36%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    panelRef: statsRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, STATS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: statsColumns,
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_complete_count.MonitorCompleteCount, {
    from: from,
    to: to
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_complete_sparklines.MonitorCompleteSparklines, {
    from: from,
    to: to
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_availability_panel.AvailabilityPanel, {
    from: from,
    to: to,
    id: "availabilityPercentageHistory"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_availability_sparklines.AvailabilitySparklines, {
    from: from,
    to: to,
    id: "availabilitySparklineHistory"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, monitorId && /*#__PURE__*/_react.default.createElement(_monitor_errors_count.MonitorErrorsCount, {
    from: from,
    to: to,
    monitorId: [monitorId],
    id: "monitorErrorsCountHistory"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, monitorId && /*#__PURE__*/_react.default.createElement(_monitor_error_sparklines.MonitorErrorSparklines, {
    from: from,
    to: to,
    monitorId: [monitorId],
    id: "monitorErrorsSparklineHistory"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_duration_panel.DurationPanel, {
    from: from,
    to: to,
    id: "durationAvgValueHistory"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_duration_sparklines.DurationSparklines, {
    from: from,
    to: to,
    id: "durationAvgSparklineHistory"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_total_runs_count.MonitorTotalRunsCount, {
    from: from,
    to: to
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      flexBasis: '60%',
      minWidth: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, DURATION_TREND_LABEL)), /*#__PURE__*/_react.default.createElement(_duration_trend.MonitorDurationTrend, {
    from: from,
    to: to
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_status_panel.MonitorStatusPanel, {
    from: from,
    to: to,
    showViewHistoryButton: false,
    periodCaption: '',
    brushable: true,
    onBrushed: handleStatusChartBrushed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_test_runs_table.TestRunsTable, {
    from: from,
    to: to,
    showViewHistoryButton: false
  }))));
};
exports.MonitorHistory = MonitorHistory;
const STATS_LABEL = _i18n.i18n.translate('xpack.synthetics.historyPanel.stats', {
  defaultMessage: 'Stats'
});
const DURATION_TREND_LABEL = _i18n.i18n.translate('xpack.synthetics.historyPanel.durationTrends', {
  defaultMessage: 'Duration trends'
});