"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorErrors = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_monitor_details_page = require("../use_monitor_details_page");
var _use_monitor_errors = require("../hooks/use_monitor_errors");
var _synthetics_date_picker = require("../../common/date_picker/synthetics_date_picker");
var _errors_tab_content = require("./errors_tab_content");
var _monitor_pending_wrapper = require("../monitor_pending_wrapper");
var _use_selected_location = require("../hooks/use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorErrors = () => {
  const {
    errorStates,
    loading,
    data
  } = (0, _use_monitor_errors.useMonitorErrors)();
  const location = (0, _use_selected_location.useSelectedLocation)();
  const initialLoading = !data;
  const emptyState = !loading && errorStates && (errorStates === null || errorStates === void 0 ? void 0 : errorStates.length) === 0;
  const redirect = (0, _use_monitor_details_page.useMonitorDetailsPage)();
  if (redirect) {
    return redirect;
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_pending_wrapper.MonitorPendingWrapper, null, /*#__PURE__*/_react.default.createElement(_synthetics_date_picker.SyntheticsDatePicker, {
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), initialLoading && /*#__PURE__*/_react.default.createElement(LoadingErrors, null), emptyState && /*#__PURE__*/_react.default.createElement(EmptyErrors, null), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      visibility: initialLoading || emptyState ? 'collapse' : 'initial'
    }
  }, /*#__PURE__*/_react.default.createElement(_errors_tab_content.ErrorsTabContent, {
    location: location,
    errorStates: errorStates !== null && errorStates !== void 0 ? errorStates : [],
    loading: loading
  })));
};
exports.MonitorErrors = MonitorErrors;
const LoadingErrors = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    style: {
      height: '65vh'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, CHEKCING_FOR_ERRORS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, LOADING_DESCRIPTION)));
};
const EmptyErrors = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    style: {
      height: '65vh'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, NO_ERRORS_FOUND)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, KEEP_CALM)));
};
const KEEP_CALM = _i18n.i18n.translate('xpack.synthetics.errors.keepCalm', {
  defaultMessage: 'This monitor ran successfully during the selected period. Increase the time range to check for older errors.'
});
const NO_ERRORS_FOUND = _i18n.i18n.translate('xpack.synthetics.errors.noErrorsFound', {
  defaultMessage: 'No errors found'
});
const LOADING_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.errors.loadingDescription', {
  defaultMessage: 'This will take just a second.'
});
const CHEKCING_FOR_ERRORS = _i18n.i18n.translate('xpack.synthetics.errors.checkingForErrors', {
  defaultMessage: 'Checking for errors'
});