"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorsTabContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _failed_tests_by_step = require("./failed_tests_by_step");
var _panel_with_title = require("../../common/components/panel_with_title");
var _monitor_errors_count = require("../monitor_summary/monitor_errors_count");
var _failed_tests_count = require("./failed_tests_count");
var _failed_tests = require("./failed_tests");
var _errors_list = require("./errors_list");
var _hooks = require("../../../hooks");
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorsTabContent = ({
  errorStates,
  loading,
  location
}) => {
  const time = (0, _hooks.useRefreshedRangeFromUrl)();
  const monitorId = (0, _use_monitor_query_id.useMonitorQueryId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: OVERVIEW_LABEL,
    titleLeftAlign: true,
    css: {
      minWidth: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, monitorId && /*#__PURE__*/_react.default.createElement(_monitor_errors_count.MonitorErrorsCount, {
    from: time.from,
    to: time.to,
    monitorId: [monitorId],
    id: "monitorsErrorsCountErrors"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_failed_tests_count.FailedTestsCount, {
    location: location,
    from: time.from,
    to: time.to,
    id: "failedTestsCountErrors"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: FAILED_TESTS_LABEL
  }, /*#__PURE__*/_react.default.createElement(_failed_tests.MonitorFailedTests, {
    location: location,
    time: time
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: {
      minWidth: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: ERRORS_LABEL
  }, /*#__PURE__*/_react.default.createElement(_errors_list.ErrorsList, {
    location: location,
    errorStates: errorStates,
    loading: loading
  }))), /*#__PURE__*/_react.default.createElement(_failed_tests_by_step.FailedTestsByStep, {
    time: time
  })));
};
exports.ErrorsTabContent = ErrorsTabContent;
const ERRORS_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.label', {
  defaultMessage: 'Errors'
});
const OVERVIEW_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.overview', {
  defaultMessage: 'Overview'
});
const FAILED_TESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.failedTests', {
  defaultMessage: 'Failed tests'
});