"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorDetailsUrl = exports.ErrorsList = void 0;
exports.isErrorActive = isErrorActive;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _error_details_link = require("../../common/links/error_details_link");
var _use_error_failed_step = require("../hooks/use_error_failed_step");
var _use_monitor_errors = require("../hooks/use_monitor_errors");
var _use_monitor_latest_ping = require("../hooks/use_monitor_latest_ping");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isErrorActive(item, lastErrorId, latestPingStatus) {
  // if the error is the most recent, `isActiveState`, and the monitor
  // is not yet back up, label the error as active
  return (0, _use_monitor_errors.isActiveState)(item) && lastErrorId === item.state.id && latestPingStatus !== 'up';
}
const ErrorsList = ({
  errorStates,
  loading,
  location
}) => {
  var _errorStates$, _errorStates$sort;
  const {
    monitorId: configId
  } = (0, _reactRouterDom.useParams)();
  const checkGroups = (0, _react.useMemo)(() => {
    return errorStates.map(error => error.monitor.check_group);
  }, [errorStates]);
  const {
    failedSteps
  } = (0, _use_error_failed_step.useErrorFailedStep)(checkGroups);
  const isBrowserType = ((_errorStates$ = errorStates[0]) === null || _errorStates$ === void 0 ? void 0 : _errorStates$.monitor.type) === 'browser';
  const history = (0, _reactRouterDom.useHistory)();
  const format = (0, _test_time_formats.useDateFormatForTest)();
  const selectedLocation = location;
  const {
    latestPing
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)({
    monitorId: configId,
    locationLabel: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label
  });
  const lastErrorTestRun = errorStates === null || errorStates === void 0 ? void 0 : (_errorStates$sort = errorStates.sort((a, b) => {
    return (0, _moment.default)(b.state.started_at).valueOf() - (0, _moment.default)(a.state.started_at).valueOf();
  })) === null || _errorStates$sort === void 0 ? void 0 : _errorStates$sort[0];
  const isTabletOrGreater = (0, _eui.useIsWithinMinBreakpoint)('s');
  const columns = [{
    field: 'item.state.started_at',
    name: TIMESTAMP_LABEL,
    sortable: a => {
      return (0, _moment.default)(a.state.started_at).valueOf();
    },
    render: (_value, item) => {
      var _item$state;
      const link = /*#__PURE__*/_react.default.createElement(_error_details_link.ErrorDetailsLink, {
        configId: configId,
        stateId: (_item$state = item.state) === null || _item$state === void 0 ? void 0 : _item$state.id,
        label: (0, _test_time_formats.formatTestRunAt)(item.state.started_at, format),
        locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
      });
      if (isErrorActive(item, lastErrorTestRun === null || lastErrorTestRun === void 0 ? void 0 : lastErrorTestRun.state.id, latestPing === null || latestPing === void 0 ? void 0 : latestPing.monitor.status)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center",
          wrap: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "eui-textNoWrap"
        }, link), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          iconType: "clock",
          iconSide: "right",
          css: {
            maxWidth: 'max-content'
          }
        }, ACTIVE_LABEL)));
      }
      return link;
    },
    mobileOptions: {
      header: false
    }
  }, ...(isBrowserType ? [{
    field: 'monitor.check_group',
    name: FAILED_STEP_LABEL,
    truncateText: true,
    sortable: a => {
      var _failedStep$synthetic, _failedStep$synthetic2;
      const failedStep = failedSteps.find(step => step.monitor.check_group === a.monitor.check_group);
      if (!failedStep) {
        return a.monitor.check_group;
      }
      return (_failedStep$synthetic = failedStep.synthetics) === null || _failedStep$synthetic === void 0 ? void 0 : (_failedStep$synthetic2 = _failedStep$synthetic.step) === null || _failedStep$synthetic2 === void 0 ? void 0 : _failedStep$synthetic2.name;
    },
    render: (value, item) => {
      var _failedStep$synthetic3, _failedStep$synthetic4, _failedStep$synthetic5, _failedStep$synthetic6;
      const failedStep = failedSteps.find(step => step.monitor.check_group === value);
      if (!failedStep) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "--");
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, (_failedStep$synthetic3 = failedStep.synthetics) === null || _failedStep$synthetic3 === void 0 ? void 0 : (_failedStep$synthetic4 = _failedStep$synthetic3.step) === null || _failedStep$synthetic4 === void 0 ? void 0 : _failedStep$synthetic4.index, ". ", (_failedStep$synthetic5 = failedStep.synthetics) === null || _failedStep$synthetic5 === void 0 ? void 0 : (_failedStep$synthetic6 = _failedStep$synthetic5.step) === null || _failedStep$synthetic6 === void 0 ? void 0 : _failedStep$synthetic6.name);
    }
  }] : []), {
    field: 'error.message',
    name: ERROR_MESSAGE_LABEL
  }, {
    field: 'state.duration_ms',
    name: ERROR_DURATION_LABEL,
    align: 'right',
    sortable: true,
    render: (value, item) => {
      const isActive = (0, _use_monitor_errors.isActiveState)(item);
      let activeDuration = 0;
      if (item.monitor.timespan) {
        const diff = (0, _moment.default)(item.monitor.timespan.lt).diff((0, _moment.default)(item.monitor.timespan.gte), 'millisecond');
        if (isActive) {
          const currentDiff = (0, _moment.default)().diff(item['@timestamp']);
          activeDuration = currentDiff < diff ? currentDiff : diff;
        } else {
          activeDuration = diff;
        }
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, (0, _test_time_formats.formatTestDuration)(Number(value) + activeDuration, true));
    }
  }];
  const getRowProps = item => {
    const {
      state
    } = item;
    if (state !== null && state !== void 0 && state.id) {
      return {
        'data-test-subj': `row-${state.id}`,
        onClick: evt => {
          history.push(`/monitor/${configId}/errors/${state.id}?locationId=${selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id}`);
        }
      };
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    css: {
      overflowX: isTabletOrGreater ? 'auto' : undefined
    },
    tableLayout: "auto",
    tableCaption: ERRORS_LIST_LABEL,
    loading: loading,
    items: errorStates,
    columns: columns,
    rowProps: getRowProps,
    pagination: {
      pageSizeOptions: [5, 10, 20, 50, 100]
    },
    sorting: {
      sort: {
        field: 'item.state.started_at',
        direction: 'desc'
      }
    }
  }));
};
exports.ErrorsList = ErrorsList;
const getErrorDetailsUrl = ({
  basePath,
  configId,
  stateId,
  locationId
}) => {
  return `${basePath}/app/synthetics/monitor/${configId}/errors/${stateId}?locationId=${locationId}`;
};
exports.getErrorDetailsUrl = getErrorDetailsUrl;
const ERRORS_LIST_LABEL = _i18n.i18n.translate('xpack.synthetics.errorsList.label', {
  defaultMessage: 'Errors list'
});
const ERROR_DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.errorDuration.label', {
  defaultMessage: 'Error duration'
});
const ERROR_MESSAGE_LABEL = _i18n.i18n.translate('xpack.synthetics.errorMessage.label', {
  defaultMessage: 'Error message'
});
const FAILED_STEP_LABEL = _i18n.i18n.translate('xpack.synthetics.failedStep.label', {
  defaultMessage: 'Failed step'
});
const TIMESTAMP_LABEL = _i18n.i18n.translate('xpack.synthetics.timestamp.label', {
  defaultMessage: '@timestamp'
});
const ACTIVE_LABEL = _i18n.i18n.translate('xpack.synthetics.active.label', {
  defaultMessage: 'Active'
});