"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePingStatusesIsLoading = exports.usePingStatuses = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _runtime_types = require("../../../../../../common/runtime_types");
var _state = require("../../../state");
var _use_selected_monitor = require("./use_selected_monitor");
var _use_selected_location = require("./use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePingStatuses = ({
  from,
  to,
  size,
  monitorInterval,
  lastRefresh
}) => {
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const location = (0, _use_selected_location.useSelectedLocation)();
  const pingStatusesSelector = (0, _react.useCallback)(() => {
    var _monitor$ConfigKey$CO, _location$label;
    return (0, _state.selectPingStatusesForMonitorAndLocationAsc)((_monitor$ConfigKey$CO = monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== null && _monitor$ConfigKey$CO !== void 0 ? _monitor$ConfigKey$CO : '', (_location$label = location === null || location === void 0 ? void 0 : location.label) !== null && _location$label !== void 0 ? _location$label : '');
  }, [monitor, location === null || location === void 0 ? void 0 : location.label]);
  const isLoading = (0, _reactRedux.useSelector)(_state.selectIsMonitorStatusesLoading);
  const pingStatuses = (0, _reactRedux.useSelector)(pingStatusesSelector());
  const dispatch = (0, _reactRedux.useDispatch)();
  const lastCall = (0, _react.useRef)({
    monitorId: '',
    locationLabel: '',
    to: 0,
    from: 0,
    lastRefresh: 0
  });
  const toDiff = Math.abs(lastCall.current.to - to) / (1000 * 60);
  const fromDiff = Math.abs(lastCall.current.from - from) / (1000 * 60);
  const lastRefreshDiff = Math.abs(lastCall.current.lastRefresh - lastRefresh) / (1000 * 60);
  const isDataChangedEnough = toDiff >= monitorInterval || fromDiff >= monitorInterval || lastRefreshDiff >= 3 ||
  // Minimum monitor interval
  (monitor === null || monitor === void 0 ? void 0 : monitor.id) !== lastCall.current.monitorId || (location === null || location === void 0 ? void 0 : location.label) !== lastCall.current.locationLabel;
  (0, _react.useEffect)(() => {
    if (!isLoading && isDataChangedEnough && monitor !== null && monitor !== void 0 && monitor.id && location !== null && location !== void 0 && location.label && from && to && size) {
      dispatch(_state.getMonitorPingStatusesAction.get({
        monitorId: monitor.id,
        locationId: location.label,
        from,
        to,
        size
      }));
      lastCall.current = {
        monitorId: monitor.id,
        locationLabel: location === null || location === void 0 ? void 0 : location.label,
        to,
        from,
        lastRefresh
      };
    }
    // `isLoading` shouldn't be included in deps
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, monitor === null || monitor === void 0 ? void 0 : monitor.id, location === null || location === void 0 ? void 0 : location.label, from, to, size, isDataChangedEnough, lastRefresh]);
  return pingStatuses.filter(({
    timestamp
  }) => {
    const timestampN = Number(new Date(timestamp));
    return timestampN >= from && timestampN <= to;
  });
};
exports.usePingStatuses = usePingStatuses;
const usePingStatusesIsLoading = () => {
  return (0, _reactRedux.useSelector)(_state.selectIsMonitorStatusesLoading);
};
exports.usePingStatusesIsLoading = usePingStatusesIsLoading;