"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isActiveState = void 0;
exports.useMonitorErrors = useMonitorErrors;
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/observability-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _use_selected_location = require("./use_selected_location");
var _client_defaults = require("../../../../../../common/constants/client_defaults");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorErrors(monitorIdArg) {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const timeZone = (0, _public.useTimeZone)();
  const {
    data,
    loading
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [_client_defaults.SUMMARY_FILTER, _client_defaults.EXCLUDE_RUN_ONCE_FILTER, {
            range: {
              '@timestamp': {
                gte: dateRangeStart,
                lte: dateRangeEnd,
                time_zone: timeZone
              }
            }
          }, {
            term: {
              'state.up': 0
            }
          }, {
            term: {
              config_id: monitorIdArg !== null && monitorIdArg !== void 0 ? monitorIdArg : monitorId
            }
          }, {
            term: {
              'observer.geo.name': selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label
            }
          }]
        }
      },
      sort: [{
        'state.started_at': 'desc'
      }],
      aggs: {
        errorStates: {
          terms: {
            field: 'state.id',
            size: 10000
          },
          aggs: {
            summary: {
              top_hits: {
                size: 1,
                _source: ['error', 'state', 'monitor', '@timestamp'],
                sort: [{
                  '@timestamp': 'desc'
                }]
              }
            }
          }
        }
      }
    }
  }, [lastRefresh, monitorId, monitorIdArg, dateRangeStart, dateRangeEnd, selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label], {
    name: `getMonitorErrors/${dateRangeStart}/${dateRangeEnd}`,
    isRequestReady: Boolean(selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label)
  });
  return (0, _react.useMemo)(() => {
    var _data$aggregations, _data$aggregations$er;
    const errorStates = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : (_data$aggregations$er = _data$aggregations.errorStates.buckets) === null || _data$aggregations$er === void 0 ? void 0 : _data$aggregations$er.map(loc => {
      var _loc$summary$hits$hit;
      return (_loc$summary$hits$hit = loc.summary.hits.hits) === null || _loc$summary$hits$hit === void 0 ? void 0 : _loc$summary$hits$hit[0]._source;
    });
    const hasActiveError = (errorStates === null || errorStates === void 0 ? void 0 : errorStates.some(errorState => isActiveState(errorState))) || false;
    return {
      errorStates,
      loading,
      data,
      hasActiveError
    };
  }, [data, loading]);
}
const isActiveState = item => {
  var _item$monitor$timespa, _item$monitor$timespa2;
  const timestamp = item['@timestamp'];
  const interval = (0, _moment.default)((_item$monitor$timespa = item.monitor.timespan) === null || _item$monitor$timespa === void 0 ? void 0 : _item$monitor$timespa.lt).diff((0, _moment.default)((_item$monitor$timespa2 = item.monitor.timespan) === null || _item$monitor$timespa2 === void 0 ? void 0 : _item$monitor$timespa2.gte), 'milliseconds');
  return (0, _moment.default)().diff((0, _moment.default)(timestamp), 'milliseconds') < interval;
};
exports.isActiveState = isActiveState;