"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorFailedStep = useErrorFailedStep;
var _public = require("@kbn/observability-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _data_filters = require("../../../../../../common/constants/data_filters");
var _as_mutable_array = require("../../../../../../common/utils/as_mutable_array");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useErrorFailedStep(checkGroups) {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    data,
    loading
  } = (0, _public.useEsSearch)({
    index: (checkGroups === null || checkGroups === void 0 ? void 0 : checkGroups.length) > 0 ? _constants.SYNTHETICS_INDEX_PATTERN : '',
    body: {
      size: checkGroups.length,
      query: {
        bool: {
          filter: [_data_filters.STEP_END_FILTER, {
            exists: {
              field: 'synthetics.error'
            }
          }, {
            terms: {
              'monitor.check_group': checkGroups
            }
          }]
        }
      },
      sort: (0, _as_mutable_array.asMutableArray)([{
        'synthetics.step.index': {
          order: 'asc'
        }
      }, {
        '@timestamp': {
          order: 'asc'
        }
      }]),
      _source: ['synthetics.step', 'synthetics.error', 'monitor.check_group']
    }
  }, [lastRefresh, monitorId, checkGroups], {
    name: 'getMonitorErrorFailedStep'
  });
  return (0, _react.useMemo)(() => {
    var _data$hits$hits;
    const failedSteps = ((_data$hits$hits = data === null || data === void 0 ? void 0 : data.hits.hits) !== null && _data$hits$hits !== void 0 ? _data$hits$hits : []).map(doc => {
      return doc._source;
    });
    return {
      failedSteps,
      loading
    };
  }, [data, loading]);
}