"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepFields = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _step = require("./step");
var _form_config = require("../form/form_config");
var _field = require("../form/field");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepFields = ({
  description,
  stepKey,
  readOnly = false,
  descriptionOnly = false
}) => {
  var _formConfig$stepKey;
  const {
    watch,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const [type] = watch([_types.ConfigKey.FORM_MONITOR_TYPE]);
  const formConfig = (0, _react.useMemo)(() => {
    return (0, _form_config.FORM_CONFIG)(readOnly)[type];
  }, [readOnly, type]);
  return descriptionOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, description) : /*#__PURE__*/_react.default.createElement(_step.Step, {
    description: description
  }, (_formConfig$stepKey = formConfig[stepKey]) === null || _formConfig$stepKey === void 0 ? void 0 : _formConfig$stepKey.map(field => {
    return /*#__PURE__*/_react.default.createElement(_field.Field, (0, _extends2.default)({}, field, {
      key: field.fieldKey,
      fieldError: errors[field.fieldKey]
    }));
  }));
};
exports.StepFields = StepFields;