"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _types = require("../types");
var _advanced = require("../advanced");
var _monitor_type_portal = require("./monitor_type_portal");
var _read_only_callout = require("./read_only_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorSteps = ({
  stepMap,
  projectId,
  isEditFlow = false,
  readOnly = false
}) => {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const [type] = watch([_types.ConfigKey.FORM_MONITOR_TYPE]);
  const steps = stepMap[type];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, readOnly ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_read_only_callout.ReadOnlyCallout, {
    projectId: projectId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, isEditFlow ? steps.map(step => /*#__PURE__*/_react.default.createElement("div", {
    key: step.title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, step.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), step.children), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    headingElement: "h2"
  }), /*#__PURE__*/_react.default.createElement(_advanced.AdvancedConfig, {
    readOnly: readOnly
  }), /*#__PURE__*/_react.default.createElement(_monitor_type_portal.MonitorTypePortal, {
    monitorType: type
  }));
};
exports.MonitorSteps = MonitorSteps;