"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorEditPageWithServiceAllowed = exports.MonitorEditPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _edit_monitor_not_found = require("./edit_monitor_not_found");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _runtime_types = require("../../../../../common/runtime_types");
var _state = require("../../state");
var _service_allowed_wrapper = require("../common/wrappers/service_allowed_wrapper");
var _alerting_callout = require("../common/alerting_callout/alerting_callout");
var _steps = require("./steps");
var _form = require("./form");
var _locations_loading_error = require("./locations_loading_error");
var _monitor_details_portal = require("./monitor_details_portal");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _api = require("../../state/monitor_management/api");
var _step_config = require("./steps/step_config");
var _use_monitor_not_found = require("./hooks/use_monitor_not_found");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorEditPage = () => {
  var _data$attributes$Conf, _data$attributes$Conf2;
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'edit-monitor'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'edit-monitor',
    delay: 15000
  });
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  (0, _use_breadcrumbs.useMonitorAddEditBreadcrumbs)(true);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    locationsLoaded,
    error: locationsError
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  (0, _react.useEffect)(() => {
    if (!locationsLoaded) {
      dispatch((0, _state.getServiceLocations)());
    }
  }, [locationsLoaded, dispatch]);
  const {
    data,
    loading,
    error
  } = (0, _public.useFetcher)(() => {
    return (0, _api.getMonitorAPI)({
      id: monitorId
    });
  }, []);
  const monitorNotFoundError = (0, _use_monitor_not_found.useMonitorNotFound)(error, data === null || data === void 0 ? void 0 : data.id);
  if (monitorNotFoundError) {
    return /*#__PURE__*/_react.default.createElement(_edit_monitor_not_found.EditMonitorNotFound, null);
  }
  const isReadOnly = (data === null || data === void 0 ? void 0 : data.attributes[_runtime_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _runtime_types.SourceType.PROJECT;
  const projectId = data === null || data === void 0 ? void 0 : data.attributes[_runtime_types.ConfigKey.PROJECT_ID];
  if (locationsError) {
    return /*#__PURE__*/_react.default.createElement(_locations_loading_error.LocationsLoadingError, null);
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.synthetics.monitorEditPage.error.label', {
        defaultMessage: 'Unable to load monitor configuration'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.synthetics.monitorEditPage.error.content', {
        defaultMessage: 'There was an error loading your monitor. Please try again later.'
      }))
    });
  }
  return data && locationsLoaded && !loading && !error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alerting_callout.AlertingCallout, {
    isAlertingEnabled: (_data$attributes$Conf = data.attributes[_runtime_types.ConfigKey.ALERT_CONFIG]) === null || _data$attributes$Conf === void 0 ? void 0 : (_data$attributes$Conf2 = _data$attributes$Conf.status) === null || _data$attributes$Conf2 === void 0 ? void 0 : _data$attributes$Conf2.enabled
  }), /*#__PURE__*/_react.default.createElement(_form.MonitorForm, {
    defaultValues: data === null || data === void 0 ? void 0 : data.attributes,
    readOnly: isReadOnly
  }, /*#__PURE__*/_react.default.createElement(_steps.MonitorSteps, {
    stepMap: (0, _step_config.EDIT_MONITOR_STEPS)(isReadOnly),
    isEditFlow: true,
    readOnly: isReadOnly,
    projectId: projectId
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_portal.MonitorDetailsLinkPortal, {
    configId: data === null || data === void 0 ? void 0 : data.attributes[_runtime_types.ConfigKey.CONFIG_ID],
    name: data === null || data === void 0 ? void 0 : data.attributes.name,
    updateUrl: false
  }))) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null);
};
exports.MonitorEditPage = MonitorEditPage;
const MonitorEditPageWithServiceAllowed = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_service_allowed_wrapper.ServiceAllowedWrapper, null, /*#__PURE__*/_react.default.createElement(MonitorEditPage, null)));
exports.MonitorEditPageWithServiceAllowed = MonitorEditPageWithServiceAllowed;