"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorSave = void 0;
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _api = require("../../../state/monitor_management/api");
var _kibana_service = require("../../../../../utils/kibana_service");
var _state = require("../../../state");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorSave = ({
  monitorData
}) => {
  var _core$services$theme;
  const core = (0, _public2.useKibana)();
  const theme$ = (_core$services$theme = core.services.theme) === null || _core$services$theme === void 0 ? void 0 : _core$services$theme.theme$;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const editRouteMatch = (0, _reactRouterDom.useRouteMatch)({
    path: _constants.MONITOR_EDIT_ROUTE
  });
  const isEdit = editRouteMatch === null || editRouteMatch === void 0 ? void 0 : editRouteMatch.isExact;
  const {
    data,
    status,
    loading,
    error
  } = (0, _public.useFetcher)(() => {
    if (monitorData) {
      if (isEdit) {
        return (0, _api.updateMonitorAPI)({
          id: monitorId,
          monitor: monitorData
        });
      } else {
        return (0, _api.createMonitorAPI)({
          monitor: monitorData
        });
      }
    }
  }, [monitorData]);
  (0, _react.useEffect)(() => {
    if (status === _public.FETCH_STATUS.FAILURE && error) {
      var _body$message;
      _kibana_service.kibanaService.toasts.addError({
        ...error,
        message: (_body$message = error.body.message) !== null && _body$message !== void 0 ? _body$message : error.message
      }, {
        title: MONITOR_FAILURE_LABEL
      });
    } else if (status === _public.FETCH_STATUS.SUCCESS && !loading) {
      refreshApp();
      dispatch((0, _state.cleanMonitorListState)());
      _kibana_service.kibanaService.toasts.addSuccess({
        title: monitorId ? MONITOR_UPDATED_SUCCESS_LABEL : MONITOR_SUCCESS_LABEL,
        text: (0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "synthetcsMonitorSaveSubtext"
        }, monitorId ? MONITOR_UPDATED_SUCCESS_LABEL_SUBTEXT : MONITOR_SUCCESS_LABEL_SUBTEXT), {
          theme$
        }),
        toastLifeTimeMs: 3000
      });
    }
  }, [data, status, monitorId, loading, refreshApp, dispatch, theme$, error]);
  return {
    status,
    loading,
    isEdit
  };
};
exports.useMonitorSave = useMonitorSave;
const MONITOR_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorAddedSuccessMessage', {
  defaultMessage: 'Monitor added successfully.'
});
const MONITOR_SUCCESS_LABEL_SUBTEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorAddedSuccessMessage.subtext', {
  defaultMessage: 'It will next run according to its defined schedule.'
});
const MONITOR_UPDATED_SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorEditedSuccessMessage', {
  defaultMessage: 'Monitor updated successfully.'
});
const MONITOR_FAILURE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorFailureMessage', {
  defaultMessage: 'Monitor was unable to be saved. Please try again later.'
});
const MONITOR_UPDATED_SUCCESS_LABEL_SUBTEXT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorFailureMessage.subtext', {
  defaultMessage: 'It will next run according to its defined schedule.'
});