"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorName = void 0;
var _react = require("react");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _saved_objects = require("../../../../../../common/types/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorName = ({
  search = ''
}) => {
  const [values, setValues] = (0, _react.useState)([]);
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    savedObjects
  } = (0, _public2.useKibana)().services;
  const {
    data
  } = (0, _public.useFetcher)(() => {
    const aggs = {
      monitorNames: {
        terms: {
          field: `${_saved_objects.syntheticsMonitorType}.attributes.name.keyword`,
          size: 10000
        }
      }
    };
    return savedObjects === null || savedObjects === void 0 ? void 0 : savedObjects.client.find({
      type: _saved_objects.syntheticsMonitorType,
      perPage: 0,
      aggs
    });
  }, []);
  (0, _react.useEffect)(() => {
    if (data !== null && data !== void 0 && data.aggregations) {
      var _data$aggregations;
      const newValues = (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.monitorNames.buckets.map(({
        key
      }) => key.toLowerCase());
      if (monitorId && newValues.includes(search.toLowerCase())) {
        setValues(newValues.filter(val => val !== search.toLowerCase()));
      } else {
        setValues(newValues);
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data, monitorId]);
  const hasMonitor = Boolean(search && values && values.length > 0 && (values === null || values === void 0 ? void 0 : values.includes(search.trim().toLowerCase())));
  return {
    nameAlreadyExists: hasMonitor,
    validName: hasMonitor ? '' : search
  };
};
exports.useMonitorName = useMonitorName;