"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SCHEDULED_LABEL = exports.TEST_NOW_ARIA_LABEL = exports.RunTestButton = exports.PRIVATE_AVAILABLE_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _public = require("@kbn/observability-plugin/public");
var _test_now_mode_flyout = require("../../test_now_mode/test_now_mode_flyout");
var _formatter = require("./formatter");
var _api = require("../../../state/manual_test_runs/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RunTestButton = () => {
  var _data$errors;
  const {
    watch,
    formState,
    getValues,
    handleSubmit
  } = (0, _reactHookForm.useFormContext)();
  const [inProgress, setInProgress] = (0, _react.useState)(false);
  const [testRun, setTestRun] = (0, _react.useState)();
  const handleTestNow = () => {
    const config = getValues();
    if (config && !Object.keys(formState.errors).length) {
      setInProgress(true);
      setTestRun({
        id: (0, _uuid.v4)(),
        name: config.name,
        monitor: (0, _formatter.format)(config)
      });
    }
  };
  const {
    data,
    loading: isPushing,
    error: serviceError
  } = (0, _public.useFetcher)(() => {
    // in case of test now mode outside of form add/edit, we don't need to trigger since it's already triggered
    if (testRun !== null && testRun !== void 0 && testRun.id) {
      return (0, _api.runOnceMonitor)({
        monitor: testRun.monitor,
        id: testRun.id
      });
    }
  }, [testRun === null || testRun === void 0 ? void 0 : testRun.id]);
  const locations = watch('locations');
  const {
    tooltipContent,
    isDisabled
  } = useTooltipContent(locations, formState.isValid, inProgress);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    key: tooltipContent,
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsRunTestBtn",
    color: "success",
    disabled: isDisabled,
    "aria-label": TEST_NOW_ARIA_LABEL,
    iconType: "play",
    onClick: handleSubmit(handleTestNow)
  }, RUN_TEST)), testRun && /*#__PURE__*/_react.default.createElement(_test_now_mode_flyout.TestNowModeFlyout, {
    serviceError: serviceError,
    errors: (_data$errors = data === null || data === void 0 ? void 0 : data.errors) !== null && _data$errors !== void 0 ? _data$errors : [],
    isPushing: Boolean(isPushing),
    testRun: testRun,
    name: testRun.name,
    inProgress: inProgress,
    onClose: () => {
      setTestRun(undefined);
      setInProgress(false);
    },
    onDone: () => {
      setInProgress(false);
    }
  }));
};
exports.RunTestButton = RunTestButton;
const useTooltipContent = (locations, isValid, isTestRunInProgress) => {
  var _locations$length;
  const isAnyPublicLocationSelected = locations === null || locations === void 0 ? void 0 : locations.some(loc => loc.isServiceManaged);
  const isOnlyPrivateLocations = ((_locations$length = locations === null || locations === void 0 ? void 0 : locations.length) !== null && _locations$length !== void 0 ? _locations$length : 0) > 0 && !isAnyPublicLocationSelected;
  let tooltipContent = isOnlyPrivateLocations || isValid && !isAnyPublicLocationSelected ? PRIVATE_AVAILABLE_LABEL : TEST_NOW_DESCRIPTION;
  tooltipContent = isTestRunInProgress ? TEST_SCHEDULED_LABEL : tooltipContent;
  const isDisabled = isTestRunInProgress || !isAnyPublicLocationSelected;
  return {
    tooltipContent,
    isDisabled
  };
};
const TEST_NOW_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.testRun.description', {
  defaultMessage: 'Test your monitor and verify the results before saving'
});
const TEST_SCHEDULED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.testNow.scheduled', {
  defaultMessage: 'Test is already scheduled'
});
exports.TEST_SCHEDULED_LABEL = TEST_SCHEDULED_LABEL;
const PRIVATE_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.app.testNow.available.private', {
  defaultMessage: `You can't manually start tests on a private location.`
});
exports.PRIVATE_AVAILABLE_LABEL = PRIVATE_AVAILABLE_LABEL;
const TEST_NOW_ARIA_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorList.testNow.AriaLabel', {
  defaultMessage: 'Click to run test now'
});
exports.TEST_NOW_ARIA_LABEL = TEST_NOW_ARIA_LABEL;
const RUN_TEST = _i18n.i18n.translate('xpack.synthetics.monitorList.runTest.label', {
  defaultMessage: 'Run test'
});