"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Field = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _state = require("../../../state");
var _hooks = require("../hooks");
var _controlled_field = require("./controlled_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Field = /*#__PURE__*/(0, _react.memo)(({
  component: Component,
  helpText,
  label,
  ariaLabel,
  props,
  fieldKey,
  controlled,
  shouldUseSetValue,
  required,
  validation,
  error,
  fieldError,
  dependencies,
  customHook,
  hidden
}) => {
  const {
    register,
    watch,
    control,
    setValue,
    reset,
    getFieldState,
    formState
  } = (0, _reactHookForm.useFormContext)();
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const {
    space
  } = (0, _hooks.useKibanaSpace)();
  const isEdit = (0, _hooks.useIsEditFlow)();
  const [dependenciesFieldMeta, setDependenciesFieldMeta] = (0, _react.useState)({});
  let dependenciesValues = [];
  if (dependencies) {
    dependenciesValues = watch(dependencies);
  }
  (0, _react.useEffect)(() => {
    if (dependencies) {
      dependencies.forEach(dependency => {
        setDependenciesFieldMeta(prevState => ({
          ...prevState,
          [dependency]: getFieldState(dependency)
        }));
      });
    }
    // run effect when dependencies values change, to get the most up to date meta state
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(dependenciesValues || []), dependencies, getFieldState]);
  if (hidden && hidden(dependenciesValues)) {
    return null;
  }
  const formRowProps = {
    label,
    'aria-label': ariaLabel,
    helpText,
    fullWidth: true
  };
  return controlled ? /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: fieldKey,
    rules: {
      required,
      ...(validation ? validation(dependenciesValues) : {})
    },
    render: ({
      field,
      fieldState: fieldStateT
    }) => {
      return /*#__PURE__*/_react.default.createElement(_controlled_field.ControlledField, {
        field: field,
        component: Component,
        props: props,
        shouldUseSetValue: shouldUseSetValue,
        fieldKey: fieldKey,
        customHook: customHook,
        formRowProps: formRowProps,
        fieldState: fieldStateT,
        error: error,
        dependenciesValues: dependenciesValues,
        dependenciesFieldMeta: dependenciesFieldMeta
      });
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
    isInvalid: Boolean(fieldError),
    error: (fieldError === null || fieldError === void 0 ? void 0 : fieldError.message) || error
  }), /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, register(fieldKey, {
    required,
    ...(validation ? validation(dependenciesValues) : {})
  }), props ? props({
    field: undefined,
    formState,
    setValue,
    reset,
    locations: locations.map(location => ({
      ...location,
      key: location.id
    })),
    dependencies: dependenciesValues,
    dependenciesFieldMeta,
    space: space === null || space === void 0 ? void 0 : space.id,
    isEdit
  }) : {}, {
    isInvalid: Boolean(fieldError),
    fullWidth: true
  })));
});
exports.Field = Field;