"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultFormFields = exports.formatDefaultFormValues = void 0;
var _formatters = require("../../../../../../common/formatters");
var _constants = require("../constants");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultFormFields = (spaceId = 'default') => {
  const kibanaNamespace = (0, _formatters.formatKibanaNamespace)(spaceId);
  return {
    [_types.FormMonitorType.MULTISTEP]: {
      ..._constants.DEFAULT_FIELDS[_types.DataStream.BROWSER],
      'source.inline': {
        type: 'recorder',
        script: '',
        fileName: ''
      },
      [_types.ConfigKey.FORM_MONITOR_TYPE]: _types.FormMonitorType.MULTISTEP,
      [_types.ConfigKey.NAMESPACE]: kibanaNamespace
    },
    [_types.FormMonitorType.SINGLE]: {
      ..._constants.DEFAULT_FIELDS[_types.DataStream.BROWSER],
      [_types.ConfigKey.FORM_MONITOR_TYPE]: _types.FormMonitorType.SINGLE,
      [_types.ConfigKey.NAMESPACE]: kibanaNamespace
    },
    [_types.FormMonitorType.HTTP]: {
      ..._constants.DEFAULT_FIELDS[_types.DataStream.HTTP],
      isTLSEnabled: false,
      [_types.ConfigKey.FORM_MONITOR_TYPE]: _types.FormMonitorType.HTTP,
      [_types.ConfigKey.NAMESPACE]: kibanaNamespace
    },
    [_types.FormMonitorType.TCP]: {
      ..._constants.DEFAULT_FIELDS[_types.DataStream.TCP],
      isTLSEnabled: false,
      [_types.ConfigKey.FORM_MONITOR_TYPE]: _types.FormMonitorType.TCP,
      [_types.ConfigKey.NAMESPACE]: kibanaNamespace
    },
    [_types.FormMonitorType.ICMP]: {
      ..._constants.DEFAULT_FIELDS[_types.DataStream.ICMP],
      [_types.ConfigKey.FORM_MONITOR_TYPE]: _types.FormMonitorType.ICMP,
      [_types.ConfigKey.NAMESPACE]: kibanaNamespace
    }
  };
};
exports.getDefaultFormFields = getDefaultFormFields;
const formatDefaultFormValues = monitor => {
  var _browserMonitor$Confi, _browserMonitor$Confi2, _browserMonitor$Confi3, _browserMonitor$Confi4;
  if (!monitor) return undefined;
  let formMonitorType = monitor[_types.ConfigKey.FORM_MONITOR_TYPE];
  const monitorType = monitor[_types.ConfigKey.MONITOR_TYPE];
  const monitorWithFormMonitorType = {
    ...monitor
  };

  // handle default monitor types from Uptime, which don't contain `ConfigKey.FORM_MONITOR_TYPE`
  if (!formMonitorType) {
    formMonitorType = monitorType === _types.DataStream.BROWSER ? _types.FormMonitorType.MULTISTEP : monitorType;
    monitorWithFormMonitorType[_types.ConfigKey.FORM_MONITOR_TYPE] = formMonitorType;
  }
  switch (formMonitorType) {
    case _types.FormMonitorType.MULTISTEP:
      const browserMonitor = monitor;
      return {
        ...monitorWithFormMonitorType,
        'source.inline': {
          type: (_browserMonitor$Confi = browserMonitor[_types.ConfigKey.METADATA]) !== null && _browserMonitor$Confi !== void 0 && (_browserMonitor$Confi2 = _browserMonitor$Confi.script_source) !== null && _browserMonitor$Confi2 !== void 0 && _browserMonitor$Confi2.is_generated_script ? 'recorder' : 'inline',
          script: browserMonitor[_types.ConfigKey.SOURCE_INLINE],
          fileName: (_browserMonitor$Confi3 = browserMonitor[_types.ConfigKey.METADATA]) === null || _browserMonitor$Confi3 === void 0 ? void 0 : (_browserMonitor$Confi4 = _browserMonitor$Confi3.script_source) === null || _browserMonitor$Confi4 === void 0 ? void 0 : _browserMonitor$Confi4.file_name
        }
      };
    case _types.FormMonitorType.SINGLE:
    case _types.FormMonitorType.ICMP:
      return {
        ...monitorWithFormMonitorType
      };
    case _types.FormMonitorType.HTTP:
    case _types.FormMonitorType.TCP:
      return {
        ...monitorWithFormMonitorType,
        isTLSEnabled: monitor[_types.ConfigKey.METADATA].is_tls_enabled
      };
  }
};
exports.formatDefaultFormValues = formatDefaultFormValues;