"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _code_editor = require("./code_editor");
var _script_recorder_fields = require("./script_recorder_fields");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var SourceType;
(function (SourceType) {
  SourceType["INLINE"] = "syntheticsBrowserInlineConfig";
  SourceType["SCRIPT_RECORDER"] = "syntheticsBrowserScriptRecorderConfig";
  SourceType["ZIP"] = "syntheticsBrowserZipURLConfig";
})(SourceType || (SourceType = {}));
const SourceField = ({
  onChange,
  onBlur,
  value,
  isEditFlow = false
}) => {
  const [sourceType, setSourceType] = (0, _react.useState)(value.type === 'inline' ? SourceType.INLINE : SourceType.SCRIPT_RECORDER);
  const [config, setConfig] = (0, _react.useState)(value);
  (0, _react.useEffect)(() => {
    onChange(config);
  }, [config, onChange]);
  const allTabs = [{
    id: 'syntheticsBrowserScriptRecorderConfig',
    name: isEditFlow ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.scriptRecorderEdit.label",
      defaultMessage: "Upload new script"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.scriptRecorder.label",
      defaultMessage: "Upload script"
    }),
    'data-test-subj': 'syntheticsSourceTab__scriptRecorder',
    content: /*#__PURE__*/_react.default.createElement(_script_recorder_fields.ScriptRecorderFields, {
      onChange: ({
        scriptText,
        fileName
      }) => {
        setConfig(prevConfig => ({
          ...prevConfig,
          script: scriptText,
          type: 'recorder',
          fileName
        }));
      },
      script: config.script,
      isEditable: isEditFlow,
      fileName: config.fileName
    })
  }, {
    id: 'syntheticsBrowserInlineConfig',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.addEditMonitor.scriptEditor.label",
      defaultMessage: "Script editor"
    }),
    'data-test-subj': `syntheticsSourceTab__inline`,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.addEditMonitor.scriptEditor.helpText",
        defaultMessage: "Runs Synthetic test scripts that are defined inline."
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_code_editor.CodeEditor, {
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.addEditMonitor.scriptEditor.ariaLabel', {
        defaultMessage: 'JavaScript code editor'
      }),
      id: "javascript",
      languageId: _types.MonacoEditorLangId.JAVASCRIPT,
      onChange: code => {
        setConfig(prevConfig => ({
          ...prevConfig,
          script: code
        }));
        onBlur(_types.ConfigKey.SOURCE_INLINE);
      },
      value: config.script,
      placeholder: _i18n.i18n.translate('xpack.synthetics.addEditMonitor.scriptEditor.placeholder', {
        defaultMessage: '// Paste your Playwright script here...'
      })
    }))
  }];
  if (isEditFlow) {
    allTabs.reverse();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: allTabs,
    initialSelectedTab: isEditFlow ? allTabs.find(tab => tab.id === SourceType.INLINE) : allTabs.find(tab => tab.id === sourceType),
    autoFocus: "selected",
    onTabClick: tab => {
      if (tab.id !== sourceType) {
        setConfig({
          script: '',
          type: tab.id === SourceType.INLINE ? 'inline' : 'recorder',
          fileName: ''
        });
      }
      setSourceType(tab.id);
    }
  });
};
exports.SourceField = SourceField;