"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStartedPage = exports.GettingStartedOnPrem = exports.GettingStartedLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../hooks");
var _use_locations_api = require("../settings/private_locations/hooks/use_locations_api");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _state = require("../../state");
var _ui = require("../../../../../common/constants/ui");
var _simple_monitor_form = require("./simple_monitor_form");
var _add_location_flyout = require("../settings/private_locations/add_location_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GettingStartedPage = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    canReadAgentPolicies
  } = (0, _hooks.useFleetPermissions)();
  (0, _react.useEffect)(() => {
    dispatch((0, _state.getServiceLocations)());
    if (canReadAgentPolicies) {
      dispatch(_state.getAgentPoliciesAction.get());
    }
    return () => {
      dispatch((0, _state.cleanMonitorListState)());
    };
  }, [canReadAgentPolicies, dispatch]);
  (0, _hooks.useBreadcrumbs)([{
    text: MONITORING_OVERVIEW_LABEL
  }]); // No extra breadcrumbs on overview

  const {
    locations,
    loading: allLocationsLoading
  } = (0, _hooks.useLocations)();
  const {
    loading: agentPoliciesLoading
  } = (0, _reactRedux.useSelector)(_state.selectAgentPolicies);
  const loading = allLocationsLoading || agentPoliciesLoading;
  const hasNoLocations = !allLocationsLoading && locations.length === 0;
  return !loading ? /*#__PURE__*/_react.default.createElement(Wrapper, null, hasNoLocations ? /*#__PURE__*/_react.default.createElement(GettingStartedOnPrem, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, CREATE_SINGLE_PAGE_LABEL),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, OR_LABEL, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsGettingStartedPageLink",
      href: history.createHref({
        pathname: _ui.MONITOR_ADD_ROUTE
      })
    }, SELECT_DIFFERENT_MONITOR), _i18n.i18n.translate('xpack.synthetics.gettingStarted.createSingle.description', {
      defaultMessage: ' to get started with Elastic Synthetics Monitoring.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_simple_monitor_form.SimpleMonitorForm, null)),
    footer: /*#__PURE__*/_react.default.createElement(GettingStartedLink, null)
  })) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null);
};
exports.GettingStartedPage = GettingStartedPage;
const GettingStartedOnPrem = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _hooks.useBreadcrumbs)([{
    text: MONITORING_OVERVIEW_LABEL
  }]); // No extra breadcrumbs on overview

  const isAddingNewLocation = (0, _reactRedux.useSelector)(_state.selectAddingNewPrivateLocation);
  const setIsAddingNewLocation = (0, _react.useCallback)(val => dispatch((0, _state.setAddingNewPrivateLocation)(val)), [dispatch]);
  const {
    onSubmit,
    privateLocations,
    loading
  } = (0, _use_locations_api.usePrivateLocationsAPI)();
  const handleSubmit = formData => {
    onSubmit(formData);
  };

  // make sure flyout is closed when first visiting the page
  (0, _react.useEffect)(() => {
    setIsAddingNewLocation(false);
  }, [setIsAddingNewLocation]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, GET_STARTED_LABEL),
    layout: "horizontal",
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, CREATE_LOCATION_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, PUBLIC_LOCATION_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "plusInCircleFilled",
      "data-test-subj": "gettingStartedAddLocationButton",
      onClick: () => setIsAddingNewLocation(true)
    }, CREATE_LOCATION_LABEL))),
    footer: /*#__PURE__*/_react.default.createElement(GettingStartedLink, null)
  }), isAddingNewLocation ? /*#__PURE__*/_react.default.createElement(_add_location_flyout.AddLocationFlyout, {
    setIsOpen: setIsAddingNewLocation,
    onSubmit: handleSubmit,
    privateLocations: privateLocations,
    isLoading: loading
  }) : null);
};
exports.GettingStartedOnPrem = GettingStartedOnPrem;
const GettingStartedLink = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued",
  className: "eui-displayInlineBlock"
}, FOR_MORE_INFO_LABEL), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  "data-test-subj": "syntheticsGettingStartedOnPremLink",
  href: "https://www.elastic.co/guide/en/observability/current/synthetics-get-started.html",
  target: "_blank",
  className: "eui-displayInline"
}, GETTING_STARTED_LABEL));
exports.GettingStartedLink = GettingStartedLink;
const Wrapper = _styledComponents.default.div`
  &&& {
    .euiEmptyPrompt__content {
      max-width: 40em;
      padding: 0;
    }
  }
`;
const FOR_MORE_INFO_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.forMoreInfo', {
  defaultMessage: 'For more information, read our'
});
const GETTING_STARTED_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel', {
  defaultMessage: 'Getting Started Guide'
});
const CREATE_SINGLE_PAGE_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.createSinglePageLabel', {
  defaultMessage: 'Create a single page browser monitor'
});
const GET_STARTED_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.createLocationHeading', {
  defaultMessage: 'Get started with synthetic monitoring'
});
const PRIVATE_LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.privateLocationLabel', {
  defaultMessage: 'private location'
});
const CREATE_LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.createLocationLabel', {
  defaultMessage: 'Create location'
});
const CREATE_LOCATION_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.gettingStarted.createLocationDescription",
  defaultMessage: "To start creating monitors, you first need to create a {link}. Private locations allow you to run monitors from your own premises. They require an Elastic agent and Agent policy which you can control and maintain via Fleet.",
  values: {
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsLink",
      href: "https://www.elastic.co/guide/en/observability/current/synthetics-private-location.html",
      target: "_blank"
    }, PRIVATE_LOCATION_LABEL)
  }
});
const PUBLIC_LOCATION_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.gettingStarted.publicLocationDescription",
  defaultMessage: "In {link} you can also use {elasticManagedLink}. With it, you can create and run monitors in multiple locations without having to manage your own infrastructure. Elastic takes care of software updates and capacity planning for you.",
  values: {
    elasticManagedLink: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel.elasticManagedLink', {
      defaultMessage: 'Elastic’s global managed testing infrastructure'
    })),
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsElasticCloudLink",
      href: "https://www.elastic.co/cloud/",
      target: "_blank"
    }, _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel.elasticCloudDeployments', {
      defaultMessage: 'Elastic Cloud'
    }))
  }
});
const SELECT_DIFFERENT_MONITOR = _i18n.i18n.translate('xpack.synthetics.gettingStarted.gettingStartedLabel.selectDifferentMonitor', {
  defaultMessage: 'select a different monitor type'
});
const OR_LABEL = _i18n.i18n.translate('xpack.synthetics.gettingStarted.orLabel', {
  defaultMessage: 'Or'
});
const MONITORING_OVERVIEW_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.heading', {
  defaultMessage: 'Monitors'
});