"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepDetails = ({
  checkGroup
}) => {
  const [stepIndex, setStepIndex] = _react.default.useState(1);
  const {
    data: stepsData,
    loading: stepsLoading,
    stepEnds
  } = (0, _use_journey_steps.useJourneySteps)(checkGroup);
  const step = stepEnds.find(stepN => {
    var _stepN$synthetics, _stepN$synthetics$ste;
    return ((_stepN$synthetics = stepN.synthetics) === null || _stepN$synthetics === void 0 ? void 0 : (_stepN$synthetics$ste = _stepN$synthetics.step) === null || _stepN$synthetics$ste === void 0 ? void 0 : _stepN$synthetics$ste.index) === stepIndex;
  });
  const totalSteps = stepsLoading ? 1 : stepEnds.length;
  return {
    step,
    stepIndex,
    setStepIndex,
    totalSteps,
    stepsData,
    loading: stepsLoading
  };
};
exports.useStepDetails = useStepDetails;