"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorDetailsPage = ErrorDetailsPage;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_run_error_info = require("../test_run_details/components/test_run_error_info");
var _step_duration_panel = require("../monitor_details/monitor_summary/step_duration_panel");
var _test_time_formats = require("../../utils/monitor_test_result/test_time_formats");
var _last_test_run = require("../monitor_details/monitor_summary/last_test_run");
var _use_step_details = require("./hooks/use_step_details");
var _step_details = require("../test_run_details/components/step_details");
var _panel_with_title = require("../common/components/panel_with_title");
var _use_error_failed_tests = require("./hooks/use_error_failed_tests");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _failed_tests_list = require("./components/failed_tests_list");
var _error_timeline = require("./components/error_timeline");
var _use_error_details_breadcrumbs = require("./hooks/use_error_details_breadcrumbs");
var _step_image = require("../step_details_page/step_screenshot/step_image");
var _monitor_details_panel_container = require("../monitor_details/monitor_summary/monitor_details_panel_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorDetailsPage() {
  var _failedTests$0$monito, _failedTests$, _lastTestRun$state, _data$details, _data$details2, _data$details3;
  const {
    failedTests,
    loading
  } = (0, _use_error_failed_tests.useErrorFailedTests)();
  const checkGroupId = (_failedTests$0$monito = failedTests === null || failedTests === void 0 ? void 0 : (_failedTests$ = failedTests[0]) === null || _failedTests$ === void 0 ? void 0 : _failedTests$.monitor.check_group) !== null && _failedTests$0$monito !== void 0 ? _failedTests$0$monito : '';
  const {
    data,
    isFailedStep,
    failedStep,
    loading: stepsLoading
  } = (0, _use_journey_steps.useJourneySteps)(checkGroupId);
  const lastTestRun = failedTests === null || failedTests === void 0 ? void 0 : failedTests[0];
  const startedAt = (0, _test_time_formats.useFormatTestRunAt)(lastTestRun === null || lastTestRun === void 0 ? void 0 : (_lastTestRun$state = lastTestRun.state) === null || _lastTestRun$state === void 0 ? void 0 : _lastTestRun$state.started_at);
  (0, _use_error_details_breadcrumbs.useErrorDetailsBreadcrumbs)([{
    text: startedAt
  }]);
  const stepDetails = (0, _use_step_details.useStepDetails)({
    checkGroup: lastTestRun === null || lastTestRun === void 0 ? void 0 : lastTestRun.monitor.check_group
  });
  const isBrowser = (data === null || data === void 0 ? void 0 : (_data$details = data.details) === null || _data$details === void 0 ? void 0 : _data$details.journey.monitor.type) === 'browser';
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: TIMELINE_LABEL
  }, /*#__PURE__*/_react.default.createElement(_error_timeline.ErrorTimeline, {
    lastTestRun: lastTestRun
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    style: {
      minWidth: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: FAILED_TESTS_LABEL
  }, /*#__PURE__*/_react.default.createElement(_failed_tests_list.FailedTestsList, {
    failedTests: failedTests,
    loading: loading
  })), isBrowser && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_step_details.StepDetails, stepDetails)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_last_test_run.LastTestRunComponent, {
    latestPing: lastTestRun,
    loading: loading,
    stepsData: data,
    stepsLoading: stepsLoading,
    isErrorDetails: true
  }), isBrowser && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_test_run_error_info.TestRunErrorInfo, {
    journeyDetails: data === null || data === void 0 ? void 0 : data.details,
    showErrorTitle: false,
    showErrorLogs: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      height: 'fit-content'
    }
  }, (data === null || data === void 0 ? void 0 : (_data$details2 = data.details) === null || _data$details2 === void 0 ? void 0 : _data$details2.journey) && failedStep && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, null, /*#__PURE__*/_react.default.createElement(_step_image.StepImage, {
    ping: data === null || data === void 0 ? void 0 : (_data$details3 = data.details) === null || _data$details3 === void 0 ? void 0 : _data$details3.journey,
    step: failedStep,
    isFailed: isFailedStep
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_step_duration_panel.StepDurationPanel, {
    doBreakdown: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_panel_container.MonitorDetailsPanelContainer, {
    hideLocations: true
  }))));
}
const TIMELINE_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.timeline.title', {
  defaultMessage: 'Timeline'
});
const FAILED_TESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.failedTests', {
  defaultMessage: 'Failed tests'
});