"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolvedAt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _use_find_my_killer_state = require("../hooks/use_find_my_killer_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResolvedAt = () => {
  const {
    killerState
  } = (0, _use_find_my_killer_state.useFindMyKillerState)();
  let endsAt = (0, _test_time_formats.useFormatTestRunAt)(killerState === null || killerState === void 0 ? void 0 : killerState.timestamp);
  if (!endsAt) {
    endsAt = 'N/A';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: ERROR_DURATION,
      description: endsAt
    }]
  });
};
exports.ResolvedAt = ResolvedAt;
const ERROR_DURATION = _i18n.i18n.translate('xpack.synthetics.errorDetails.resolvedAt', {
  defaultMessage: 'Resolved at'
});