"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceAllowedWrapper = exports.MONITOR_MANAGEMENT_LABEL = exports.ACCESS_RESTRICTED_MESSAGE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_service_allowed = require("../../../hooks/use_service_allowed");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServiceAllowedWrapper = ({
  children
}) => {
  const {
    isAllowed,
    signupUrl,
    loading
  } = (0, _use_service_allowed.useSyntheticsServiceAllowed)();
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoKibana",
        size: "xl"
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, LOADING_MONITOR_MANAGEMENT_LABEL)
    });
  }

  // checking for explicit false
  if (isAllowed === false) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, MONITOR_MANAGEMENT_LABEL),
      body: /*#__PURE__*/_react.default.createElement("p", null, ACCESS_RESTRICTED_MESSAGE),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "syntheticsServiceAllowedWrapperButton",
        color: "primary",
        fill: true,
        isDisabled: !signupUrl,
        href: signupUrl !== null && signupUrl !== void 0 ? signupUrl : undefined
      }, REQUEST_ACCESS_LABEL)]
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.ServiceAllowedWrapper = ServiceAllowedWrapper;
const REQUEST_ACCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.requestAccess', {
  defaultMessage: 'Request access'
});
const MONITOR_MANAGEMENT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.label', {
  defaultMessage: 'Synthetics App'
});
exports.MONITOR_MANAGEMENT_LABEL = MONITOR_MANAGEMENT_LABEL;
const LOADING_MONITOR_MANAGEMENT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.loading.label', {
  defaultMessage: 'Loading Synthetics App'
});
const ACCESS_RESTRICTED_MESSAGE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.accessRestricted', {
  defaultMessage: 'Your access to globally managed testing infrastructure is restricted.'
});
exports.ACCESS_RESTRICTED_MESSAGE = ACCESS_RESTRICTED_MESSAGE;