"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorsLink = ({
  disabled
}) => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_ERRORS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": VIEW_ERRORS,
    href: `${basePath}/app/synthetics/errors`,
    iconType: "inspect",
    isDisabled: disabled
  }));
};
exports.ErrorsLink = ErrorsLink;
const VIEW_ERRORS = _i18n.i18n.translate('xpack.synthetics.monitorSummary.viewErrors', {
  defaultMessage: 'View errors'
});