"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsDatePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyntheticsDatePicker = ({
  fullWidth
}) => {
  const [getUrlParams, updateUrl] = (0, _hooks.useUrlParams)();
  const {
    commonlyUsedRanges
  } = (0, _react.useContext)(_contexts.SyntheticsSettingsContext);
  const {
    refreshApp
  } = (0, _react.useContext)(_contexts.SyntheticsRefreshContext);
  const {
    data
  } = (0, _react.useContext)(_contexts.SyntheticsStartupPluginsContext);

  // read time from state and update the url
  const sharedTimeState = data === null || data === void 0 ? void 0 : data.query.timefilter.timefilter.getTime();
  const {
    dateRangeStart: start,
    dateRangeEnd: end
  } = getUrlParams();
  (0, _react.useEffect)(() => {
    const {
      from,
      to
    } = sharedTimeState !== null && sharedTimeState !== void 0 ? sharedTimeState : {};
    if (from !== start || to !== end) {
      // if it's coming url. let's update shared state
      data === null || data === void 0 ? void 0 : data.query.timefilter.timefilter.setTime({
        from: start,
        to: end
      });
    }

    // only need at start, rest date picker on change fucn will take care off
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const euiCommonlyUsedRanges = commonlyUsedRanges ? commonlyUsedRanges.map(({
    from,
    to,
    display
  }) => {
    return {
      start: from,
      end: to,
      label: display
    };
  }) : _constants.CLIENT_DEFAULTS.COMMONLY_USED_DATE_RANGES;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    width: fullWidth ? 'full' : 'auto',
    start: start,
    end: end,
    commonlyUsedRanges: euiCommonlyUsedRanges,
    onTimeChange: ({
      start: startN,
      end: endN
    }) => {
      var _data$query, _data$query$timefilte;
      if (data !== null && data !== void 0 && (_data$query = data.query) !== null && _data$query !== void 0 && (_data$query$timefilte = _data$query.timefilter) !== null && _data$query$timefilte !== void 0 && _data$query$timefilte.timefilter) {
        data === null || data === void 0 ? void 0 : data.query.timefilter.timefilter.setTime({
          from: startN,
          to: endN
        });
      }
      updateUrl({
        dateRangeStart: startN,
        dateRangeEnd: endN
      });
      refreshApp();
    },
    onRefresh: refreshApp
  });
};
exports.SyntheticsDatePicker = SyntheticsDatePicker;