"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPermissionsTooltip = exports.NEED_PRIVATE_LOCATIONS_PERMISSION = exports.NEED_PERMISSIONS_PRIVATE_LOCATIONS = exports.FleetPermissionsCallout = exports.CANNOT_SAVE_INTEGRATION_LABEL = exports.CANNOT_PERFORM_ACTION_SYNTHETICS = exports.ALL = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetPermissionsCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: NEED_PERMISSIONS_PRIVATE_LOCATIONS,
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, NEED_PRIVATE_LOCATIONS_PERMISSION));
};

/**
 * If any of the canEditSynthetics or canUpdatePrivateMonitor is false, then wrap the children with a tooltip
 * so that a reason can be conveyed to the user explaining why the action is disabled.
 */
exports.FleetPermissionsCallout = FleetPermissionsCallout;
const NoPermissionsTooltip = ({
  canEditSynthetics = true,
  canUpdatePrivateMonitor = true,
  canAddPrivateMonitor = true,
  children
}) => {
  const disabledMessage = getRestrictionReasonLabel(canEditSynthetics, canUpdatePrivateMonitor, canAddPrivateMonitor);
  if (disabledMessage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: disabledMessage
    }, /*#__PURE__*/_react.default.createElement("span", null, children));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.NoPermissionsTooltip = NoPermissionsTooltip;
function getRestrictionReasonLabel(canEditSynthetics = true, canUpdatePrivateMonitor = true, canAddPrivateMonitor = true) {
  return !canEditSynthetics ? CANNOT_PERFORM_ACTION_SYNTHETICS : !canUpdatePrivateMonitor ? CANNOT_PERFORM_ACTION_FLEET : !canAddPrivateMonitor ? PRIVATE_LOCATIONS_NOT_ALLOWED_MESSAGE : undefined;
}
const NEED_PERMISSIONS_PRIVATE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privateLocations.needPermissions', {
  defaultMessage: "You're missing some Kibana privileges to manage private locations"
});
exports.NEED_PERMISSIONS_PRIVATE_LOCATIONS = NEED_PERMISSIONS_PRIVATE_LOCATIONS;
const ALL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.priviledges.all', {
  defaultMessage: 'All'
});
exports.ALL = ALL;
const NEED_PRIVATE_LOCATIONS_PERMISSION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.monitorManagement.privateLocations.needFleetPermission",
  defaultMessage: "You are not authorized to manage private locations. It requires the {all} Kibana privilege for both Fleet and Integrations.",
  values: {
    all: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, `"${ALL}"`)
  }
});
exports.NEED_PRIVATE_LOCATIONS_PERMISSION = NEED_PRIVATE_LOCATIONS_PERMISSION;
const CANNOT_SAVE_INTEGRATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.cannotSaveIntegration', {
  defaultMessage: 'You are not authorized to manage private locations. It requires the "All" Kibana privilege for both Fleet and Integrations.'
});
exports.CANNOT_SAVE_INTEGRATION_LABEL = CANNOT_SAVE_INTEGRATION_LABEL;
const CANNOT_PERFORM_ACTION_FLEET = _i18n.i18n.translate('xpack.synthetics.monitorManagement.noFleetPermission', {
  defaultMessage: 'You are not authorized to perform this action. It requires the "All" Kibana privilege for Integrations.'
});
const CANNOT_PERFORM_ACTION_SYNTHETICS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.noSyntheticsPermissions', {
  defaultMessage: 'You do not have sufficient permissions to perform this action.'
});
exports.CANNOT_PERFORM_ACTION_SYNTHETICS = CANNOT_PERFORM_ACTION_SYNTHETICS;
const PRIVATE_LOCATIONS_NOT_ALLOWED_MESSAGE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privateLocationsNotAllowedMessage', {
  defaultMessage: 'You do not have permission to add monitors to private locations. Contact your administrator to request access.'
});