"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTypeBadge = MonitorTypeBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _runtime_types = require("../../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MonitorTypeBadge({
  monitor,
  ariaLabel,
  onClick,
  onKeyPress
}) {
  const badge = /*#__PURE__*/_react.default.createElement(EuiBadgeStyled, {
    "data-is-clickable": !!onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: getMonitorTypeBadgeIcon(monitor)
  }), ' ', getMonitorTypeBadgeTitle(monitor));
  return onClick ? /*#__PURE__*/_react.default.createElement("div", {
    title: ariaLabel,
    "aria-label": ariaLabel,
    onClick: onClick,
    onKeyPress: onKeyPress
  }, badge) : badge;
}
function getMonitorTypeBadgeTitle(monitor) {
  var _monitor$type, _monitor$type2;
  switch (monitor[_runtime_types.ConfigKey.FORM_MONITOR_TYPE]) {
    case _runtime_types.FormMonitorType.TCP:
    case _runtime_types.FormMonitorType.HTTP:
    case _runtime_types.FormMonitorType.ICMP:
      return monitor === null || monitor === void 0 ? void 0 : (_monitor$type = monitor.type) === null || _monitor$type === void 0 ? void 0 : _monitor$type.toUpperCase();
    case _runtime_types.FormMonitorType.SINGLE:
      return 'Page';
    case _runtime_types.FormMonitorType.MULTISTEP:
      return 'Journey';
  }
  switch (monitor === null || monitor === void 0 ? void 0 : monitor.type) {
    case _runtime_types.DataStream.BROWSER:
      return 'Journey';
    default:
      return monitor === null || monitor === void 0 ? void 0 : (_monitor$type2 = monitor.type) === null || _monitor$type2 === void 0 ? void 0 : _monitor$type2.toUpperCase();
  }
}
function getMonitorTypeBadgeIcon(monitor) {
  return (monitor === null || monitor === void 0 ? void 0 : monitor.type) === 'browser' ? 'videoPlayer' : 'online';
}
const EuiBadgeStyled = (0, _common.euiStyled)(_eui.EuiBadge)`
  ${({
  'data-is-clickable': dataIsClickable
}) => dataIsClickable ? `cursor: pointer;` : ''}
  &&& {
    .euiBadge__text {
      display: flex;
      align-items: center;
      gap: 4px;
    }
  }
`;