"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _client_defaults = require("../../../../../../common/constants/synthetics/client_defaults");
var _hooks = require("../../../hooks");
var _state = require("../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  AUTOREFRESH_INTERVAL_SECONDS,
  AUTOREFRESH_IS_PAUSED
} = _client_defaults.CLIENT_DEFAULTS_SYNTHETICS;
const replaceDefaults = ({
  refreshPaused,
  refreshInterval
}) => {
  return {
    refreshInterval: refreshInterval === AUTOREFRESH_INTERVAL_SECONDS ? undefined : refreshInterval,
    refreshPaused: refreshPaused === AUTOREFRESH_IS_PAUSED ? undefined : refreshPaused
  };
};
const AutoRefreshButton = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const refreshPaused = (0, _reactRedux.useSelector)(_state.selectRefreshPaused);
  const refreshInterval = (0, _reactRedux.useSelector)(_state.selectRefreshInterval);
  const [getUrlsParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    refreshInterval: urlRefreshInterval,
    refreshPaused: urlIsPaused
  } = getUrlsParams();
  const isFirstRender = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    if (isFirstRender.current) {
      // sync url state with redux state on first render
      dispatch((0, _state.setRefreshIntervalAction)(urlRefreshInterval));
      dispatch((0, _state.setRefreshPausedAction)(urlIsPaused));
      isFirstRender.current = false;
    } else {
      // sync redux state with url state on subsequent renders
      if (urlRefreshInterval !== refreshInterval || urlIsPaused !== refreshPaused) {
        updateUrlParams(replaceDefaults({
          refreshInterval,
          refreshPaused
        }), true);
      }
    }
  }, [updateUrlParams, refreshInterval, refreshPaused, urlRefreshInterval, urlIsPaused, dispatch]);
  const onRefreshChange = newProps => {
    dispatch((0, _state.setRefreshIntervalAction)(newProps.refreshInterval / 1000));
    dispatch((0, _state.setRefreshPausedAction)(newProps.isPaused));
    updateUrlParams(replaceDefaults({
      refreshInterval: newProps.refreshInterval / 1000,
      refreshPaused: newProps.isPaused
    }), true);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAutoRefreshButton, {
    size: "m",
    isPaused: refreshPaused,
    refreshInterval: refreshInterval * 1000,
    onRefreshChange: onRefreshChange,
    shortHand: true
  });
};
exports.AutoRefreshButton = AutoRefreshButton;