"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _state = require("../../../state");
var _actions = require("../../../state/settings/actions");
var _use_alerting_defaults = require("../../settings/alerting_defaults/hooks/use_alerting_defaults");
var _contexts = require("../../../contexts");
var _runtime_types = require("../../../../../../common/runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertingCallout = ({
  isAlertingEnabled
}) => {
  var _useSyntheticsStartPl, _useSyntheticsStartPl2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [url, setUrl] = (0, _react.useState)('');
  const {
    defaultConnectors,
    settingsLoading
  } = (0, _use_alerting_defaults.useAlertingDefaults)();
  const {
    data: {
      monitors
    },
    loaded: monitorsLoaded
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const syntheticsLocators = (_useSyntheticsStartPl = (0, _contexts.useSyntheticsStartPlugins)()) === null || _useSyntheticsStartPl === void 0 ? void 0 : (_useSyntheticsStartPl2 = _useSyntheticsStartPl.share) === null || _useSyntheticsStartPl2 === void 0 ? void 0 : _useSyntheticsStartPl2.url.locators;
  const locator = syntheticsLocators === null || syntheticsLocators === void 0 ? void 0 : syntheticsLocators.get(_common.syntheticsSettingsLocatorID);
  (0, _react.useEffect)(() => {
    async function generateUrl() {
      const settingsUrl = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({}));
      setUrl(settingsUrl);
    }
    generateUrl();
  }, [locator]);
  const hasDefaultConnector = Boolean(defaultConnectors === null || defaultConnectors === void 0 ? void 0 : defaultConnectors.length) || !settingsLoading && Boolean(defaultConnectors === null || defaultConnectors === void 0 ? void 0 : defaultConnectors.length);
  const hasAlertingConfigured = isAlertingEnabled !== null && isAlertingEnabled !== void 0 ? isAlertingEnabled : monitorsLoaded && monitors.some(monitor => {
    var _monitor$attributes$C, _monitor$attributes$C2;
    return (_monitor$attributes$C = monitor.attributes[_runtime_types.ConfigKey.ALERT_CONFIG]) === null || _monitor$attributes$C === void 0 ? void 0 : (_monitor$attributes$C2 = _monitor$attributes$C.status) === null || _monitor$attributes$C2 === void 0 ? void 0 : _monitor$attributes$C2.enabled;
  });
  const showCallout = url && !hasDefaultConnector && hasAlertingConfigured;
  (0, _react.useEffect)(() => {
    dispatch(_actions.getDynamicSettingsAction.get());
  }, [dispatch]);
  return showCallout ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.alerting.noConnectorsCallout.header",
      defaultMessage: "Alerts are not being sent"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerting.noConnectorsCallout.content",
    defaultMessage: "You have monitors with alerting enabled, but there is no default connector configured to send those alerts."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsAlertingCalloutLinkButtonButton",
    href: url,
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alerting.noConnectorsCallout.button",
    defaultMessage: "Configure now"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
};
exports.AlertingCallout = AlertingCallout;