"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleAlertFlyoutButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _manage_rules_link = require("../common/links/manage_rules_link");
var _translations = require("./hooks/translations");
var _use_synthetics_alert = require("./hooks/use_synthetics_alert");
var _state = require("../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ToggleAlertFlyoutButton = () => {
  var _application$capabili, _application$capabili2;
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    application
  } = (0, _public.useKibana)().services;
  const hasUptimeWrite = (_application$capabili = application === null || application === void 0 ? void 0 : (_application$capabili2 = application.capabilities.uptime) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.save) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const {
    EditAlertFlyout,
    loading
  } = (0, _use_synthetics_alert.useSyntheticsAlert)(isOpen);
  const monitorStatusAlertContextMenuItem = {
    'aria-label': _translations.ToggleFlyoutTranslations.toggleMonitorStatusAriaLabel,
    'data-test-subj': 'xpack.synthetics.toggleAlertFlyout',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _translations.ToggleFlyoutTranslations.toggleMonitorStatusContent), loading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null))),
    onClick: () => {
      dispatch((0, _state.setAlertFlyoutVisible)(true));
      setIsOpen(false);
    },
    toolTipContent: !hasUptimeWrite ? noWritePermissionsTooltipContent : null,
    disabled: !hasUptimeWrite || loading,
    icon: 'bell'
  };
  const managementContextItem = {
    'aria-label': _translations.ToggleFlyoutTranslations.navigateToAlertingUIAriaLabel,
    'data-test-subj': 'xpack.synthetics.navigateToAlertingUi',
    name: /*#__PURE__*/_react.default.createElement(_manage_rules_link.ManageRulesLink, null),
    icon: 'tableOfContents'
  };
  const panels = [{
    id: 0,
    items: [monitorStatusAlertContextMenuItem, managementContextItem]
  }];
  const alertFlyoutVisible = (0, _reactRedux.useSelector)(_state.selectAlertFlyoutVisibility);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
      color: "text",
      "aria-label": _translations.ToggleFlyoutTranslations.toggleButtonAriaLabel,
      "data-test-subj": "xpack.synthetics.alertsPopover.toggleButton",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => setIsOpen(!isOpen)
    }, _translations.ToggleFlyoutTranslations.alertsAndRules),
    closePopover: () => setIsOpen(false),
    isOpen: isOpen,
    ownFocus: true,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })), alertFlyoutVisible && EditAlertFlyout);
};
exports.ToggleAlertFlyoutButton = ToggleAlertFlyoutButton;
const noWritePermissionsTooltipContent = _i18n.i18n.translate('xpack.synthetics.alertDropdown.noPermissions', {
  defaultMessage: 'You do not have sufficient permissions to perform this action.'
});