"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsAlert = void 0;
var _public = require("@kbn/observability-plugin/public");
var _reactRedux = require("react-redux");
var _react = require("react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _state = require("../../../state");
var _api = require("../../../state/alert_rules/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyntheticsAlert = isOpen => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [alert, setAlert] = (0, _react.useState)(null);
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    if (isOpen) {
      return (0, _api.enableDefaultAlertingAPI)();
    }
  }, [isOpen]);
  (0, _react.useEffect)(() => {
    if (data) {
      setAlert(data);
    }
  }, [data]);
  const {
    triggersActionsUi
  } = (0, _public2.useKibana)().services;
  const EditAlertFlyout = (0, _react.useMemo)(() => {
    if (!alert) {
      return null;
    }
    return triggersActionsUi.getEditRuleFlyout({
      onClose: () => dispatch((0, _state.setAlertFlyoutVisible)(false)),
      hideInterval: true,
      initialRule: alert
    });
  }, [alert, dispatch, triggersActionsUi]);
  return (0, _react.useMemo)(() => ({
    loading,
    EditAlertFlyout
  }), [EditAlertFlyout, loading]);
};
exports.useSyntheticsAlert = useSyntheticsAlert;