"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleFlyoutTranslations = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ToggleFlyoutTranslations = {
  toggleButtonAriaLabel: _i18n.i18n.translate('xpack.synthetics.alertsRulesPopover.toggleButton.ariaLabel', {
    defaultMessage: 'Open alerts and rules menu'
  }),
  toggleMonitorStatusAriaLabel: _i18n.i18n.translate('xpack.synthetics.toggleAlertFlyout.ariaLabel', {
    defaultMessage: 'Open add rule flyout'
  }),
  toggleMonitorStatusContent: _i18n.i18n.translate('xpack.synthetics.toggleAlertButton.content', {
    defaultMessage: 'Monitor status rule'
  }),
  navigateToAlertingUIAriaLabel: _i18n.i18n.translate('xpack.synthetics.app.navigateToAlertingUi', {
    defaultMessage: 'Leave Synthetics and go to Alerting Management page'
  }),
  navigateToAlertingButtonContent: _i18n.i18n.translate('xpack.synthetics.app.navigateToAlertingButton.content', {
    defaultMessage: 'Manage rules'
  }),
  alertsAndRules: _i18n.i18n.translate('xpack.synthetics.alerts.toggleAlertFlyoutButtonText', {
    defaultMessage: 'Alerts and rules'
  })
};
exports.ToggleFlyoutTranslations = ToggleFlyoutTranslations;