"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlsFormatters = void 0;
var _monitor_management = require("../../runtime_types/monitor_management");
var _formatting_utils = require("../formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tlsFormatters = {
  [_monitor_management.ConfigKey.TLS_CERTIFICATE_AUTHORITIES]: _formatting_utils.tlsValueToYamlFormatter,
  [_monitor_management.ConfigKey.TLS_CERTIFICATE]: _formatting_utils.tlsValueToYamlFormatter,
  [_monitor_management.ConfigKey.TLS_KEY]: _formatting_utils.tlsValueToYamlFormatter,
  [_monitor_management.ConfigKey.TLS_KEY_PASSPHRASE]: _formatting_utils.tlsValueToStringFormatter,
  [_monitor_management.ConfigKey.TLS_VERIFICATION_MODE]: _formatting_utils.tlsValueToStringFormatter,
  [_monitor_management.ConfigKey.TLS_VERSION]: _formatting_utils.tlsArrayToYamlFormatter
};
exports.tlsFormatters = tlsFormatters;