"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.icmpFormatters = void 0;
var _formatting_utils = require("../formatting_utils");
var _monitor_management = require("../../runtime_types/monitor_management");
var _formatters = require("../common/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const icmpFormatters = {
  [_monitor_management.ConfigKey.HOSTS]: null,
  [_monitor_management.ConfigKey.WAIT]: _formatting_utils.secondsToCronFormatter,
  [_monitor_management.ConfigKey.MODE]: null,
  [_monitor_management.ConfigKey.IPV4]: null,
  [_monitor_management.ConfigKey.IPV6]: null,
  ..._formatters.commonFormatters
};
exports.icmpFormatters = icmpFormatters;