"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.httpFormatters = void 0;
var _formatters = require("../tls/formatters");
var _monitor_management = require("../../runtime_types/monitor_management");
var _formatters2 = require("../common/formatters");
var _formatting_utils = require("../formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const httpFormatters = {
  [_monitor_management.ConfigKey.MAX_REDIRECTS]: null,
  [_monitor_management.ConfigKey.REQUEST_METHOD_CHECK]: null,
  [_monitor_management.ConfigKey.RESPONSE_BODY_INDEX]: null,
  [_monitor_management.ConfigKey.RESPONSE_HEADERS_INDEX]: null,
  [_monitor_management.ConfigKey.METADATA]: _formatting_utils.objectToJsonFormatter,
  [_monitor_management.ConfigKey.URLS]: null,
  [_monitor_management.ConfigKey.USERNAME]: null,
  [_monitor_management.ConfigKey.PASSWORD]: null,
  [_monitor_management.ConfigKey.PROXY_URL]: null,
  [_monitor_management.ConfigKey.PROXY_HEADERS]: _formatting_utils.objectToJsonFormatter,
  [_monitor_management.ConfigKey.PORT]: null,
  [_monitor_management.ConfigKey.RESPONSE_BODY_CHECK_NEGATIVE]: _formatting_utils.arrayToJsonFormatter,
  [_monitor_management.ConfigKey.RESPONSE_BODY_CHECK_POSITIVE]: _formatting_utils.arrayToJsonFormatter,
  [_monitor_management.ConfigKey.RESPONSE_JSON_CHECK]: _formatting_utils.arrayToJsonFormatter,
  [_monitor_management.ConfigKey.RESPONSE_HEADERS_CHECK]: _formatting_utils.objectToJsonFormatter,
  [_monitor_management.ConfigKey.RESPONSE_STATUS_CHECK]: _formatting_utils.arrayToJsonFormatter,
  [_monitor_management.ConfigKey.REQUEST_HEADERS_CHECK]: _formatting_utils.objectToJsonFormatter,
  [_monitor_management.ConfigKey.REQUEST_BODY_CHECK]: fields => {
    var _fields$ConfigKey$REQ, _fields$ConfigKey$REQ2;
    return (_fields$ConfigKey$REQ = fields[_monitor_management.ConfigKey.REQUEST_BODY_CHECK]) !== null && _fields$ConfigKey$REQ !== void 0 && _fields$ConfigKey$REQ.value ? JSON.stringify((_fields$ConfigKey$REQ2 = fields[_monitor_management.ConfigKey.REQUEST_BODY_CHECK]) === null || _fields$ConfigKey$REQ2 === void 0 ? void 0 : _fields$ConfigKey$REQ2.value) : null;
  },
  [_monitor_management.ConfigKey.RESPONSE_BODY_MAX_BYTES]: null,
  [_monitor_management.ConfigKey.MODE]: null,
  [_monitor_management.ConfigKey.IPV4]: null,
  [_monitor_management.ConfigKey.IPV6]: null,
  ..._formatters.tlsFormatters,
  ..._formatters2.commonFormatters
};
exports.httpFormatters = httpFormatters;