"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlsValueToYamlFormatter = exports.tlsValueToStringFormatter = exports.tlsArrayToYamlFormatter = exports.stringToJsonFormatter = exports.secondsToCronFormatter = exports.replaceStringWithParams = exports.objectToJsonFormatter = exports.arrayToJsonFormatter = void 0;
var _lightweight_param_formatter = require("./lightweight_param_formatter");
var _variable_parser = _interopRequireDefault(require("./variable_parser"));
var _runtime_types = require("../runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayToJsonFormatter = (fields, key) => {
  var _ref;
  const value = (_ref = fields[key]) !== null && _ref !== void 0 ? _ref : [];
  return value.length ? JSON.stringify(value) : null;
};
exports.arrayToJsonFormatter = arrayToJsonFormatter;
const objectToJsonFormatter = (fields, fieldKey) => {
  var _ref2;
  const value = (_ref2 = fields[fieldKey]) !== null && _ref2 !== void 0 ? _ref2 : {};
  if (Object.keys(value).length === 0) return null;
  return JSON.stringify(value);
};

// only add tls settings if they are enabled by the user and isEnabled is true
exports.objectToJsonFormatter = objectToJsonFormatter;
const tlsValueToYamlFormatter = (fields, key) => {
  var _fields$ConfigKey$MET;
  if ((_fields$ConfigKey$MET = fields[_runtime_types.ConfigKey.METADATA]) !== null && _fields$ConfigKey$MET !== void 0 && _fields$ConfigKey$MET.is_tls_enabled) {
    var _ref3;
    const tlsValue = (_ref3 = fields[key]) !== null && _ref3 !== void 0 ? _ref3 : '';
    return tlsValue ? JSON.stringify(tlsValue) : null;
  } else {
    return null;
  }
};
exports.tlsValueToYamlFormatter = tlsValueToYamlFormatter;
const tlsValueToStringFormatter = (fields, key) => {
  var _fields$ConfigKey$MET2;
  if ((_fields$ConfigKey$MET2 = fields[_runtime_types.ConfigKey.METADATA]) !== null && _fields$ConfigKey$MET2 !== void 0 && _fields$ConfigKey$MET2.is_tls_enabled) {
    var _ref4;
    const tlsValue = (_ref4 = fields[key]) !== null && _ref4 !== void 0 ? _ref4 : '';
    return tlsValue || null;
  } else {
    return null;
  }
};
exports.tlsValueToStringFormatter = tlsValueToStringFormatter;
const tlsArrayToYamlFormatter = (fields, key) => {
  var _fields$ConfigKey$MET3;
  if ((_fields$ConfigKey$MET3 = fields[_runtime_types.ConfigKey.METADATA]) !== null && _fields$ConfigKey$MET3 !== void 0 && _fields$ConfigKey$MET3.is_tls_enabled) {
    var _ref5;
    const tlsValue = (_ref5 = fields[key]) !== null && _ref5 !== void 0 ? _ref5 : [];
    return tlsValue.length ? JSON.stringify(tlsValue) : null;
  } else {
    return null;
  }
};
exports.tlsArrayToYamlFormatter = tlsArrayToYamlFormatter;
const stringToJsonFormatter = (fields, key) => {
  var _ref6;
  const value = (_ref6 = fields[key]) !== null && _ref6 !== void 0 ? _ref6 : '';
  return value ? JSON.stringify(value) : null;
};
exports.stringToJsonFormatter = stringToJsonFormatter;
const replaceStringWithParams = (value, params, logger) => {
  if (!value || typeof value === 'boolean') {
    return value;
  }
  try {
    if (typeof value !== 'string') {
      const strValue = JSON.stringify(value);
      const parsedVars = _variable_parser.default.parse(strValue);
      const parseValue = (0, _lightweight_param_formatter.replaceVarsWithParams)(parsedVars, params);
      return JSON.parse(parseValue);
    }
    const parsedVars = _variable_parser.default.parse(value);
    return (0, _lightweight_param_formatter.replaceVarsWithParams)(parsedVars, params);
  } catch (e) {
    logger === null || logger === void 0 ? void 0 : logger.error(`error parsing vars for value ${JSON.stringify(value)}, ${e}`);
  }
  return value;
};
exports.replaceStringWithParams = replaceStringWithParams;
const secondsToCronFormatter = (fields, key) => {
  var _ref7;
  const value = (_ref7 = fields[key]) !== null && _ref7 !== void 0 ? _ref7 : '';
  return value ? `${value}s` : null;
};
exports.secondsToCronFormatter = secondsToCronFormatter;