"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSyntheticsPolicy = exports.PARAMS_KEYS_TO_SKIP = void 0;
var _lodash = require("lodash");
var _formatters = require("./browser/formatters");
var _monitor_management = require("../constants/monitor_management");
var _formatting_utils = require("./formatting_utils");
var _formatters2 = require("./formatters");
var _runtime_types = require("../runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PARAMS_KEYS_TO_SKIP = ['secrets', 'fields', _runtime_types.ConfigKey.LOCATIONS, _runtime_types.ConfigKey.TLS_VERSION, _runtime_types.ConfigKey.SOURCE_PROJECT_CONTENT, _runtime_types.ConfigKey.SOURCE_INLINE];
exports.PARAMS_KEYS_TO_SKIP = PARAMS_KEYS_TO_SKIP;
const formatSyntheticsPolicy = (newPolicy, monitorType, config, params, isLegacy) => {
  var _dataStream$vars2;
  const configKeys = Object.keys(config);
  const formattedPolicy = (0, _lodash.cloneDeep)(newPolicy);
  const currentInput = formattedPolicy.inputs.find(input => input.type === `synthetics/${monitorType}`);
  const dataStream = currentInput === null || currentInput === void 0 ? void 0 : currentInput.streams.find(stream => stream.data_stream.dataset === monitorType);
  formattedPolicy.inputs.forEach(input => input.enabled = false);
  if (currentInput && dataStream) {
    // reset all data streams to enabled false
    formattedPolicy.inputs.forEach(input => input.enabled = false);
    // enable only the input type and data stream that matches the monitor type.
    currentInput.enabled = true;
    dataStream.enabled = true;
  }
  configKeys.forEach(key => {
    var _dataStream$vars;
    const configItem = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$vars = dataStream.vars) === null || _dataStream$vars === void 0 ? void 0 : _dataStream$vars[key];
    if (configItem) {
      if (_formatters2.syntheticsPolicyFormatters[key]) {
        var _syntheticsPolicyForm;
        configItem.value = (_syntheticsPolicyForm = _formatters2.syntheticsPolicyFormatters[key]) === null || _syntheticsPolicyForm === void 0 ? void 0 : _syntheticsPolicyForm.call(_formatters2.syntheticsPolicyFormatters, config, key);
      } else if (key === _runtime_types.ConfigKey.MONITOR_SOURCE_TYPE && isLegacy) {
        configItem.value = undefined;
      } else {
        configItem.value = config[key] === undefined || config[key] === null ? null : config[key];
      }
      if (!PARAMS_KEYS_TO_SKIP.includes(key)) {
        configItem.value = (0, _formatting_utils.replaceStringWithParams)(configItem.value, params);
      }
    }
  });

  // TODO: remove this once we remove legacy support
  const throttling = dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$vars2 = dataStream.vars) === null || _dataStream$vars2 === void 0 ? void 0 : _dataStream$vars2[_monitor_management.LegacyConfigKey.THROTTLING_CONFIG];
  if (throttling) {
    throttling.value = _formatters.throttlingFormatter === null || _formatters.throttlingFormatter === void 0 ? void 0 : (0, _formatters.throttlingFormatter)(config, _runtime_types.ConfigKey.THROTTLING_CONFIG);
  }
  return {
    formattedPolicy,
    hasDataStream: Boolean(dataStream),
    hasInput: Boolean(currentInput)
  };
};
exports.formatSyntheticsPolicy = formatSyntheticsPolicy;